import matplotlib.pyplot as plt
import numpy as np

plt.rcParams['font.sans-serif'] = ['SimHei'] 
plt.rcParams['axes.unicode_minus'] = False  
plt.figure(dpi=150)

x = np.arange(7)
width = 0.3

bm = [3.36, 9.57, 14.64, 25.79, 41.36, 92.50, 249.43]
mdq = [6.29, 22.50, 22.93, 50.79, 59.79, 142.43, 489.14]

name_list = [128, 256, 512, 1024, 2048, 4096, 8192]

plt.bar(x - 1 / 2 * width, [item * 2 for item in bm], width=width, label='ABM', fc='dodgerblue')
plt.bar(x + 1 / 2 * width, np.array(mdq), width=width, label='MDQ', fc='orangered', tick_label=name_list)


plt.xlabel("The number of transactions per block")
plt.ylabel("The time of block construction (ms)")
plt.ylim(ymax=700)
plt.legend(loc='upper left')
plt.savefig("BuildCostWithTxInBlock")
plt.show()
