import numpy as np
from scipy.spatial.distance import cdist
from scipy.spatial.distance import squareform
def show(dataSet, k, centroids, clusterAssment):
    from matplotlib import pyplot as plt
    numSamples, dim = dataSet.shape
    mark = ['or', 'ob', 'og', 'ok', '^r', '+r', 'sr', 'dr', '<r', 'pr']

    for i in range(numSamples):
        markIndex = int(clusterAssment[i])
        plt.plot(dataSet[i, 0], dataSet[i, 1], mark[markIndex])
    mark = ['Dr', 'Db', 'Dg', 'Dk', '^b', '+b', 'sb', 'db', '<b', 'pb']
    for i in range(k):
        plt.plot(centroids[i, 0], centroids[i, 1], mark[i], markersize=12)
    plt.show()
def distEclud(vecA,vecB):
    return sqrt(sum(power(vecA-vecB,2)))
def extract_cluster(densitySortArr,closestNodeIdArr, classNum,gamma):
    n=densitySortArr.shape[0]
    labels=np.full((n,),-1)
    corePoints =  np.argsort(-gamma)[: classNum]

    labels[corePoints]=range(len(corePoints))

    densitySortList=densitySortArr.tolist()

    densitySortList.reverse()

    for nodeId in densitySortList:
        if(labels[nodeId]==-1):

            labels[nodeId]=labels[closestNodeIdArr[nodeId]]
    return corePoints,labels

def CFSFDP(data,dc):
    n,m=data.shape

    disMat = squareform(pdist(data,metric='euclidean'))

    densityArr = np.where(disMat < dc, 1, 0).sum(axis=1)

    densitySortArr=np.argsort(densityArr)

    closestDisOverSelfDensity = np.zeros((n,))

    closestNodeIdArr = np.zeros((n,), dtype=np.int32)

    for index,nodeId in enumerate(densitySortArr):

        nodeIdArr = densitySortArr[index+1:]

        if nodeIdArr.size != 0:

            largerDistArr = disMat[nodeId][nodeIdArr]

            closestDisOverSelfDensity[nodeId] = np.min(largerDistArr)

            min_distance_index = np.argwhere(largerDistArr == closestDisOverSelfDensity[nodeId])[0][0]

            closestNodeIdArr[nodeId] = nodeIdArr[min_distance_index]
        else:

            closestDisOverSelfDensity[nodeId] = np.max(closestDisOverSelfDensity)
            closestNodeIdArr[nodeId] = nodeId

    normal_den = (densityArr - np.min(densityArr)) / (np.max(densityArr) - np.min(densityArr))
    normal_dis = (closestDisOverSelfDensity - np.min(closestDisOverSelfDensity)) / (
                np.max(closestDisOverSelfDensity) - np.min(closestDisOverSelfDensity))
    aver = np.sum(normal_den) / m
    gamma = normal_den * normal_dis

    return densityArr,densitySortArr,closestDisOverSelfDensity,closestNodeIdArr,gamma
from scipy.spatial.distance import pdist
from scipy.spatial.distance import squareform

import numpy as np
from scipy.spatial import distance_matrix
from sklearn.neighbors import KernelDensity



import numpy as np
from scipy.sparse.csgraph import minimum_spanning_tree, shortest_path
from scipy.spatial.distance import cdist
from sklearn.neighbors import NearestNeighbors


def compute_cvdd_corrected(X, labels,k=7, eps=1e-10):
    N, _ = X.shape
    unique_labels = np.unique(labels)


    nbrs = NearestNeighbors(n_neighbors=k).fit(X)
    distances, _ = nbrs.kneighbors(X)
    Den = np.mean(distances, axis=1) + eps
    fDen = Den / (np.max(Den) + eps)


    Den_i = Den.reshape(-1, 1)
    Den_j = Den.reshape(1, -1)
    Rel = Den_i / (Den_j + eps)
    Rel_ji = Den_j / (Den_i + eps)
    fRel = 1 - np.exp(-np.abs(Rel + Rel_ji - 2))


    pairwise_dist = cdist(X, X, 'euclidean')
    drD = pairwise_dist + fRel * (Den_i + Den_j)
    mst = minimum_spanning_tree(drD).toarray()
    conD = np.maximum(mst, mst.T)


    pD = shortest_path(conD, directed=False)
    max_finite = np.max(pD[~np.isinf(pD)]) if np.any(~np.isinf(pD)) else 1
    pD[np.isinf(pD)] = max_finite * 100


    fDen_prod = np.sqrt(np.outer(fDen, fDen))
    DD = fDen_prod * conD


    sep, com = [], []
    for cluster in unique_labels:
        mask = labels == cluster
        other_mask = ~mask


        if other_mask.any():
            cross_dd = DD[mask][:, other_mask]
            valid_dd = cross_dd[cross_dd > eps]
            sep.append(np.min(valid_dd) if valid_dd.size > 0 else 0.0)
        else:
            sep.append(0.0)


        if np.sum(mask) < 2:
            com.append(0.0)
            continue
        intra_pD = pD[mask][:, mask]
        upper_tri = intra_pD[np.triu_indices_from(intra_pD, k=1)]
        if len(upper_tri) == 0:
            com.append(0.0)
            continue
        mean_pD = np.mean(upper_tri)
        std_pD = np.std(upper_tri)
        com.append((1.0 / np.sum(mask)) * std_pD * mean_pD)


    total_sep = np.sum(sep)
    total_com = np.sum(com) + eps
    return total_sep / total_com
import xlwt
def main14(data,dc,k1):
    minK = 2
    maxK = int(np.ceil(data.shape[0] ** 0.5))
    book = xlwt.Workbook()

    sheet1 = book.add_sheet(u'sheet1', cell_overwrite_ok=True)
    from sklearn.cluster import KMeans
    index = np.zeros((maxK - minK))
    pairwise_distances = cdist(data, data)
    densityArr, densitySortArr, closestDisOverSelfDensity, closestNodeIdArr, gamma = CFSFDP(data, dc)
    for k in range(minK, maxK):
        corePoints, labels = extract_cluster(densitySortArr, closestNodeIdArr, k, gamma)
        index[k - minK] = compute_cvdd_corrected(
            data, labels,k1
        )
        sheet1.write(k, 1, index[k - minK])
    book.save('D://data//test14.xls')
    est_k = index.argmax() + minK
    print('For Iris:\nSelected k =', est_k)




