import numpy as np
from scipy.spatial.distance import cdist
from scipy.spatial.distance import squareform
def show(dataSet, k, centroids, clusterAssment):
    from matplotlib import pyplot as plt
    numSamples, dim = dataSet.shape
    mark = ['or', 'ob', 'og', 'ok', '^r', '+r', 'sr', 'dr', '<r', 'pr']

    for i in range(numSamples):
        markIndex = int(clusterAssment[i])
        plt.plot(dataSet[i, 0], dataSet[i, 1], mark[markIndex])
    mark = ['Dr', 'Db', 'Dg', 'Dk', '^b', '+b', 'sb', 'db', '<b', 'pb']
    for i in range(k):
        plt.plot(centroids[i, 0], centroids[i, 1], mark[i], markersize=12)
    plt.show()
def distEclud(vecA,vecB):
    return sqrt(sum(power(vecA-vecB,2)))
def extract_cluster(densitySortArr,closestNodeIdArr, classNum,gamma):
    n=densitySortArr.shape[0]
    labels=np.full((n,),-1)
    corePoints =  np.argsort(-gamma)[: classNum]

    labels[corePoints]=range(len(corePoints))

    densitySortList=densitySortArr.tolist()

    densitySortList.reverse()

    for nodeId in densitySortList:
        if(labels[nodeId]==-1):

            labels[nodeId]=labels[closestNodeIdArr[nodeId]]
    return corePoints,labels


def CFSFDP(data,dc):
    n,m=data.shape

    disMat = squareform(pdist(data,metric='euclidean'))

    densityArr = np.where(disMat < dc, 1, 0).sum(axis=1)

    densitySortArr=np.argsort(densityArr)

    closestDisOverSelfDensity = np.zeros((n,))

    closestNodeIdArr = np.zeros((n,), dtype=np.int32)

    for index,nodeId in enumerate(densitySortArr):

        nodeIdArr = densitySortArr[index+1:]

        if nodeIdArr.size != 0:

            largerDistArr = disMat[nodeId][nodeIdArr]

            closestDisOverSelfDensity[nodeId] = np.min(largerDistArr)

            min_distance_index = np.argwhere(largerDistArr == closestDisOverSelfDensity[nodeId])[0][0]

            closestNodeIdArr[nodeId] = nodeIdArr[min_distance_index]
        else:

            closestDisOverSelfDensity[nodeId] = np.max(closestDisOverSelfDensity)
            closestNodeIdArr[nodeId] = nodeId

    normal_den = (densityArr - np.min(densityArr)) / (np.max(densityArr) - np.min(densityArr))
    normal_dis = (closestDisOverSelfDensity - np.min(closestDisOverSelfDensity)) / (
                np.max(closestDisOverSelfDensity) - np.min(closestDisOverSelfDensity))
    aver = np.sum(normal_den) / m
    gamma = normal_den * normal_dis

    return densityArr,densitySortArr,closestDisOverSelfDensity,closestNodeIdArr,gamma
from scipy.spatial.distance import pdist
from scipy.spatial.distance import squareform

import numpy as np
from scipy.spatial import distance_matrix
from sklearn.neighbors import KernelDensity

from sklearn.metrics import pairwise_distances

import numpy as np


def WB_index(X, labels, M):

    centroids = []
    for i in range(M):
        cluster_points = X[labels == i]
        centroid = np.mean(cluster_points, axis=0)
        centroids.append(centroid)
    centroids = np.array(centroids)


    ssw = 0.0
    for i in range(M):
        cluster_points = X[labels == i]
        if len(cluster_points) == 0:
            continue
        distances = np.linalg.norm(cluster_points - centroids[i], axis=1)
        ssw += np.sum(distances ** 2)


    global_center = np.mean(X, axis=0)


    ssb = 0.0
    for i in range(M):
        cluster_points = X[labels == i]
        n_i = len(cluster_points)
        if n_i == 0:
            continue
        distance = np.linalg.norm(centroids[i] - global_center)
        ssb += n_i * (distance ** 2)


    if ssb == 0:
        return np.inf
    wb = M * (ssw / ssb)
    return wb
import xlwt
def main15(data,dc):
    minK = 2
    maxK = int(np.ceil(data.shape[0] ** 0.5))
    book = xlwt.Workbook()
    sheet1 = book.add_sheet(u'sheet1', cell_overwrite_ok=True)
    index = np.zeros((maxK - minK))
    pairwise_distances = cdist(data, data)
    densityArr, densitySortArr, closestDisOverSelfDensity, closestNodeIdArr, gamma = CFSFDP(data, dc)
    for k in range(minK, maxK):
        corePoints, labels = extract_cluster(densitySortArr, closestNodeIdArr, k, gamma)
        index[k - minK] = WB_index(data, labels,k)
        #print(index[k - minK] )
        sheet1.write(k, 1, index[k - minK])
    book.save('D://data//test15.xls')
    est_k = index.argmin() + minK
    print('For Iris:\nSelected k =', est_k)
