import torch
import torch.nn as nn
import torch.nn.functional as F
import numpy as np
import copy


class Config(object):


    def __init__(self, embedding):
        self.POIdata ='./shanghaiPOIdata.csv'
        self.data_path = './Datas/POItxt.txt'
        self.edge_path = './data/POIgeo.csv'
        self.model_name = 'GeoDFnet'
        self.class_list = [x.strip() for x in open('./Datas/class_shangaipoi.txt').readlines()]
        self.vocab_path ='./Datas/vocab.pkl'
        self.save_path = './Save_path/' + self.model_name + '.ckpt'
        self.log_path = './Log/' + self.model_name
        self.embedding_pretrained = torch.tensor(
            np.load('./Datas/' + embedding)["embeddings"].astype('float32'))\
            if embedding != 'random' else None
        self.device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

        self.dropout = 0.5
        self.require_improvement = 1000
        self.num_classes = len(self.class_list)
        self.n_vocab = 0

        self.batch_size = 2048
        self.num_epochs = 10

        self.pad_size = 32
        self.learning_rate = 1e-3
        self.embed = self.embedding_pretrained.size(1)\
            if self.embedding_pretrained is not None else 300
        self.dim_model = 300
        self.hidden = 512
        self.last_hidden = 256
        self.num_head = 4
        self.num_encoder = 2
        self.save_dir = './Save_data/' + self.model_name

