import os
os.environ['CMDSTAN'] = "D:/anaconda/envs/Desktop/Library/bin/cmdstan"

import pandas as pd
import numpy as np
from datetime import datetime, timedelta
import sys
import matplotlib.pyplot as plt
import warnings
warnings.simplefilter(action='ignore')
sys.path.append("../")
from kats.consts import TimeSeriesData
from kats.models.prophet import ProphetModel, ProphetParams
air_passengers_df_1 = pd.read_csv('D:/dataset/point.csv')
all_forecasts = pd.DataFrame()
a=0
for i in range(3932):
    air_passengers_df = air_passengers_df_1[['time', f'{a}']]
    air_passengers_ts = TimeSeriesData(air_passengers_df)
    split = int(0.8 * len(air_passengers_df))
    train_ts = air_passengers_ts[0:split]
    test_ts = air_passengers_ts[split:]
    params = ProphetParams(seasonality_prior_scale=  0.0079060432109077,
                           yearly_seasonality= True,
                           weekly_seasonality= True,
                           daily_seasonality= True,
                           changepoint_prior_scale=  0.6866488450042998,
                           changepoint_range=  0.5000000000000001 ,
                           seasonality_mode= 'additive'
        )
    model = ProphetModel(data=train_ts, params=params)
    model.fit()
    forecast = model.predict(steps=7,freq='12D',include_history=True)
    fcst_data = forecast[['time', 'fcst']].rename(columns={'fcst': f'fcst_{a}'})
    if all_forecasts.empty:
        all_forecasts = fcst_data
    else:
        all_forecasts = all_forecasts.merge(fcst_data, on='time', how='outer')
    a+=1
all_forecasts.to_csv('D:/combined_proforecasts.csv', index=False)