import os
os.environ['CMDSTAN'] = "D:/anaconda/envs/Desktop/Library/bin/cmdstan"
import ax
import pandas as pd
import kats.utils.time_series_parameter_tuning as tpt
from kats.consts import ModelEnum, SearchMethodEnum, TimeSeriesData
from kats.models.arima import ARIMAModel, ARIMAParams
from kats.models.prophet import ProphetModel, ProphetParams
import numpy as np
from ax.core.parameter import ChoiceParameter, FixedParameter, ParameterType
from ax.models.random.sobol import SobolGenerator
from ax.models.random.uniform import UniformGenerator
import warnings
warnings.simplefilter(action='ignore')
air_passengers_df_1 = pd.read_csv('D:/dataset/10point.csv')
parameters_grid_search =  [
{
    "name": "seasonality_prior_scale",
    "type": "choice","value_type": "float",
    "values": list(np.logspace(-4, 1, endpoint=True)),
    "is_ordered": True,
},
{
    "name": "yearly_seasonality",
    "type": "choice",
    "value_type": "bool",
    "values": [True,False],
},
{
    "name": "weekly_seasonality",
    "type": "choice",
    "value_type": "bool",
    "values": [True,False],},
{
    "name": "daily_seasonality",
    "type": "choice","value_type": "bool",
    "values": [True,False],
},
{
    "name": "seasonality_mode",
    "type": "choice",
    "value_type": "str",
    "values": ["additive","multiplicative"],
},
{
    "name": "changepoint_prior_scale",
    "type": "choice",
    "value_type": "float",
    "values": list(np.logspace(-3, 1, endpoint=True)),
    "is_ordered": True,
},
{
    "name": "changepoint_range",
    "type": "choice",
    "value_type": "float",
    "values": list(np.arange(0, 1,0.02)),
    "is_ordered": True,
},
]
def evaluation_function(params):
    params1 = ProphetParams(
        seasonality_prior_scale=params['seasonality_prior_scale'],
        yearly_seasonality=params["yearly_seasonality"],
        weekly_seasonality=params["weekly_seasonality"],
        daily_seasonality=params["daily_seasonality"],
        seasonality_mode=params["seasonality_mode"],
        changepoint_prior_scale=params['changepoint_prior_scale'],
        changepoint_range=params['changepoint_range'],
    )
    a=0
    error=0
    for i in range(10):
        air_passengers_df = air_passengers_df_1[['time', f'{a}']]
        air_passengers_ts = TimeSeriesData(air_passengers_df)
        split = int(0.8 * len(air_passengers_df))
        train_ts = air_passengers_ts[0:split]
        test_ts = air_passengers_ts[split:]
        model = ProphetModel(train_ts, params1)
        model.fit()
        model_pred = model.predict(steps=7,freq='12D',include_history=False)
        error =np.mean(np.abs(model_pred['fcst'].values - test_ts.value.values))+error
        a+=1
    return error/10
parameter_tuner_grid = tpt.SearchMethodFactory.create_search_method(
    objective_name="evaluation_metric",
    parameters=parameters_grid_search,
    selected_search_method=SearchMethodEnum.BAYES_OPT,
    evaluation_function=evaluation_function,
    bootstrap_size=500,
)
parameter_tuner_grid.generate_evaluate_new_parameter_values(
    evaluation_function=evaluation_function
    )
parameter_tuning_results_grid = (
    parameter_tuner_grid.list_parameter_value_scores()
    )
parameter_tuning_results_grid.to_csv(f'D:/prophet_beys.csv', index=False)
