package CP_Algorithms;

import java.util.ArrayList;
import java.util.Random;

import DatacenterSpec.Container;
import DatacenterSpec.PM;
import DatacenterSpec.PowerPM;
import DatacenterSpec.VM;
import ExpConfig.Result;
import WOA_Config.PowerWhale;
import WOA_Config.Whale;

public class DCP {

	private ArrayList<Container> containerSpecList;			//list of all containers in experiment 
	private ArrayList<PowerPM> pmSpecList;					//list of all PMs in experiment
		
	private int NW;
	private int iterN;
	private double OLT = .8;					//default overloading threshold is set to 80%  
		
	private Result optResult;
		
	public DCP(int NW, int iterN, ArrayList<Container> containerSpecList, ArrayList<PM> pmSpecList)
	{
		this.NW = NW;
		this.iterN = iterN;
		
		this.containerSpecList = new ArrayList<Container>(containerSpecList);
		this.pmSpecList = this.copyPMlist_PowerPMlist(pmSpecList);			//assign normal PMs to PowerPMs
		
		
		this.optResult = new Result("DCP");
	}

	
	public DCP(int NW, int iterN, ArrayList<Container> containerSpecList, ArrayList<PM> pmSpecList, double OLT)
	{
		this(NW, iterN, containerSpecList, pmSpecList);
		this.OLT = OLT;
	}
	
	/**
	 * copy
	 * @param tmpPmSpecList
	 */
	private ArrayList<PowerPM> copyPMlist_PowerPMlist(ArrayList<PM> tmpPmSpecList)
	{
		ArrayList<PowerPM> tmpPowerPMSpecList = new ArrayList<PowerPM>();
		
		for(PM tmpPM: tmpPmSpecList)
		{
			tmpPowerPMSpecList.add(new PowerPM(tmpPM.getId(), tmpPM.getRam(), tmpPM.getMips()));
		}
		return tmpPowerPMSpecList;
	}

	public PowerWhale startAlgorithm() {
		// ***** steps in alg 1. DWO-CP algorithm **** //
				
		//step 1: initialization 
		//int iterN = 10;
		int it = 0;
		ArrayList<PowerWhale> solutionList = new ArrayList<PowerWhale> ();
		
		//step 2: construct a list of solutions 
		solutionList = this.intSolutionList();
		solutionList = this.repairSolutionList(solutionList);
				
		do {
		//step 3 - 7
			solutionList = updateSolutionList(solutionList);
		
		//implement fitness method -- utilization
		
		it++;
		}while(it<this.iterN);
				
		/*//TBR 
		System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
		+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: Counter of the loop in the update solution: " + this.loopCounter);/**/
		
		PowerWhale bestSolution = solutionList.get(findBestSolution(solutionList));
		
		//repair best solution by trying to migrate containers from oltPMs 
		//bestSolution = this.repairBestSolution(bestSolution);
		
		this.optResult.setContNum(this.countTotContainerSolution(bestSolution));
		this.optResult.setPower(bestSolution.getTotPowerConsumption());
		this.optResult.setPmNum(bestSolution.getActivePmNo());
		this.optResult.setSolNum(this.NW);
		this.optResult.setSearchSpace(this.iterN);
		this.optResult.setIdlePmNumber(bestSolution.getIdlePmNumber());
		this.optResult.setAvgUtil(bestSolution.getAvgUtilLevel());
		this.optResult.setPMsOLT(bestSolution.getTotOverLoadedPMs(this.OLT));
		
		return bestSolution;
	}	
	
	/**
	 * initializes a single solution by placing containers randomly to PMs
	 * @param contList a list of containers to be placed on pmSpecList
	 * @param pmSpecList a list of PMs to host contList
	 * @return PowerWhale: a single solution of List of PMs hosting a list of containers 
	 */
	private PowerWhale intSingleSolution(ArrayList<Container> contList, ArrayList<PowerPM> pmSpecList) {
		PowerWhale singleSolution = new PowerWhale();		
		int contNo = contList.size();
		int pmNo = pmSpecList.size();
		
		Random random = new Random();
		
		//copy pmSpecList to pmlist of the solution
		for(int i=0; i < pmNo; i++)
		{
			PowerPM pm = new PowerPM(i, pmSpecList.get(i).getRam(), pmSpecList.get(i).getMips());
			singleSolution.addPM(pm);
		}
		
		for(int i=0; i < contNo; i++)
		{
			Container cont = contList.get(i);
			int pmIndex = 0;
			PowerPM tmpPm = null;

			pmIndex = random.nextInt(pmNo);
			tmpPm = singleSolution.getPMbyIndex(pmIndex);
			tmpPm.addContainer(cont);
										
			singleSolution.setPMbyIndex(pmIndex, tmpPm);
		}
		
		return singleSolution;
	}

	private int countTotContainerSolution(PowerWhale solution) 
	{		
		ArrayList<PowerPM> pmList = solution.getPmList();
		int contCounter = 0;
		
		for(PowerPM pm: pmList)
		{
			contCounter += pm.getContainerList().size();
		}
		
		return contCounter;
	}

	private PowerWhale intBestSolution(ArrayList<Container> contList, ArrayList<PowerPM> pmSpecList) {
		PowerWhale bestSolution = new PowerWhale();		
		int contNo = contList.size();
		int pmNo = pmSpecList.size();
		
		for(int i=0; i < pmNo; i++)
		{
			PowerPM pm = new PowerPM(i, pmSpecList.get(i).getRam(), pmSpecList.get(i).getMips());
			bestSolution.addPM(pm);
		}
		
		int containerIndex = 0;			//used to keep track of all already placed containers
		for(int i=0; i < pmNo; i++)
		{
			PowerPM pm = bestSolution.getPMbyIndex(i);
			
			for(; containerIndex < contNo; containerIndex++)
			{
				Container cont = contList.get(containerIndex);
				if(pm.canHost(cont))
				{
					pm.addContainer(cont);
				}
				else
					break;
			}
			bestSolution.setPMbyIndex(i, pm);
		}
		
		//TBR
		/*System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
				+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: "
				+ "power consumed best solution " + bestSolution.getTotPowerConsumption()
				+ ", number of running PMs: " + bestSolution.getPmList().size()
				+ ", idle pm number = " + bestSolution.getIdlePmNumber()); //*/
		
		return bestSolution;
	}
	
	/**
	 * initializes a list of solutions, each solution is a whale of PMs hosting containers
	 * @return
	 */
	private ArrayList<PowerWhale> intSolutionList() {
		ArrayList<PowerWhale> solutionList = new ArrayList<PowerWhale>();			
		
		//*
		//initialize the best solution using first fit
		solutionList.add(this.removeIdlePmsInSingleSolution(this.intBestSolution(containerSpecList, pmSpecList)));
				
		for(int i=1; i < this.NW; i++)
		{
			PowerWhale singleSolution = new PowerWhale();
			singleSolution = this.intSingleSolution(this.containerSpecList, this.pmSpecList);
			solutionList.add(singleSolution);
		}
		
		return solutionList;
	}
	
	private ArrayList<PowerWhale> updateSolutionList(ArrayList<PowerWhale> solutionList)
	{
		
//step 3: finding best solution 
		int bestSolutionIndex;
		PowerWhale bestSolution;
		
		bestSolutionIndex = findBestSolution(solutionList);
		bestSolution = solutionList.get(bestSolutionIndex);
		
//step 4: update each search agent i.e. whale solution 
		for(int r = 0; r < solutionList.size(); r++) 
		{			
//step 5: update the current solution 
			PowerWhale currentSolution = solutionList.get(r);
			
			if(currentSolution.getTotPowerConsumption() < bestSolution.getTotPowerConsumption())
			{
				bestSolutionIndex = r;
				bestSolution = currentSolution;
							
				continue;
			}
				
			PowerWhale randomSolution = this.intSingleSolution(this.containerSpecList, this.pmSpecList);

			currentSolution = updateSingleSolution(currentSolution, bestSolution, randomSolution);
			//currentSolution = this.removeIdlePmsInSingleSolution(currentSolution);

			currentSolution = this.repairSolution(currentSolution);
			
			solutionList.set(r, currentSolution);
		}
		
		return solutionList;
	}
	
	private int findBestSolution(ArrayList<PowerWhale> solutionList) {
		int bestSolutionIndex = 0;
		
		for(int i=1; i < solutionList.size(); i++) {
			if(solutionList.get(i).getTotPowerConsumption() < solutionList.get(bestSolutionIndex).getTotPowerConsumption())
			{
				bestSolutionIndex = i;
			}
		}
		return bestSolutionIndex;
	}
	
	private PowerWhale updateSingleSolution(PowerWhale currentSolution, PowerWhale bestSolution, PowerWhale randomSolution)
	{
		Random random = new Random();
		double rand;
		double a;
		double cf_1;
		double cf_2;
		double prob;
		double dir, dir_dash;
		int pmNo;
		
		a = random.nextDouble() * 2 ;
		rand = random.nextDouble();
		cf_1 = 2 * a * rand - a;	//in the WOA paper , cf_1 is called A
		cf_2 = 2 * rand;			//in the WOA papr, cd_2 is called C
		prob = random.nextDouble();
		
		ArrayList<Container> contList = new ArrayList<Container>();
		ArrayList<PowerPM> pmList = new ArrayList<PowerPM>();
		
		pmList = currentSolution.getPmList();
		pmNo = pmList.size();
		
		for(int pmIndex = 0; pmIndex < pmList.size(); pmIndex++)
		{
			PowerPM curPM = pmList.get(pmIndex);
			contList.addAll(curPM.getContainerList());
		}
		
		
		for(Container curCont: contList)
		{
			boolean migrateFalg = false;
			int tarPM_id, curPM_id, randPM_id, bsPM_id;
			
			curPM_id = currentSolution.getPMindexbyContainer(curCont);
			randPM_id = randomSolution.getPMindexbyContainer(curCont);
			bsPM_id = bestSolution.getPMindexbyContainer(curCont);
			
				
			//do {
				
				//a in the original WOA paper should be a double number decreasing from 2 to 0, for example 1.8, 1.6 .. etc, while in DWO paper a is integer
			
				if(prob < .5 && Math.abs(cf_1) < 1) {				//encircling Prey
						dir = Math.abs( cf_2 * (double) randPM_id - curPM_id);
						tarPM_id = (int) Math.ceil( (double) bsPM_id - cf_1 *  dir ) % pmNo;							
				}
				
				else if (prob < .5 &&  Math.abs(cf_1) >= 1){		//spiral move							
						dir = Math.abs( cf_2 * (double) randPM_id - curPM_id );
						tarPM_id = (int) Math.ceil( (double) randPM_id - cf_1 *  dir ) % pmNo ;							
				}
				else {												//spiral update
						double z = (random.nextDouble() * (1 - (-1))) + (-1);		//in the WOA paper, z is called l
						double b = 1;
						
						dir_dash = Math.abs( bsPM_id - curPM_id);
						tarPM_id = (int) Math.ceil( dir_dash * Math.exp(z * b) * Math.cos(2 * Math.PI * z) + (double) bsPM_id ) % pmNo;							
				}
				
				tarPM_id = Math.abs(tarPM_id);
				migrateFalg = currentSolution.migrateContainer(curPM_id, tarPM_id, curCont);
				
				if(migrateFalg == false)
				{
					a = random.nextDouble() * 2 ;
					rand = random.nextDouble();
					cf_1 = 2 * a * rand - a;	//in the WOA paper , cf_1 is called A
					cf_2 = 2 * rand;			//in the WOA papr, cd_2 is called C
					prob = random.nextDouble();
				}
				/*//TBR
				else
				{
					System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
							+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: " + "migrate is true");
				}/**/
			//}while(!migrateFalg);
		}
		
		return currentSolution;
	}
	public Result getOptResult()
	{
		return this.optResult;
	}
	
	private PowerWhale removeIdlePmsInSingleSolution(PowerWhale solution)
	{
		ArrayList<PowerPM> pmList = solution.getPmList();
		
		for(int i=0; i < pmList.size(); i++)
		{
			PowerPM pm = pmList.get(i);
			if(pm.getUtilization() == 0)
			{
				pmList.remove(i);
				i--;
			}
		}			
		
		solution.setPmList(pmList);
		return solution;
	}
	private PowerWhale repairSolution(PowerWhale solution)
	{
		ArrayList<PowerPM> pmList = solution.getPmList();
		Random random = new Random();
		
		for(int i=0; i < pmList.size(); i++)
		{
			PowerPM pm = pmList.get(i);
			
			while(pm.getTotAllocatedMips() > pm.getMips() || pm.getTotAllocatedRam() > pm.getRam())
			{
				ArrayList<Container> contList = pm.getContainerList();
				Container cont = contList.remove(0);
				
				boolean contPlace = false;
				int pmIndex = 0;
				PowerPM tmpPm = null;
						
				while(!contPlace)
				{
					pmIndex = random.nextInt(pmList.size());
					tmpPm = pmList.get(pmIndex);
					
					if(tmpPm.canHost(cont))		
					{
						tmpPm.addContainer(cont);
						contPlace = true;
					}
				}
				
				pm.setContainerList(contList);
				pmList.set(pmIndex, tmpPm);
			}
			pmList.set(i, pm);
		}
		solution.setPmList(pmList);
		
		return solution;
	}
	
	private ArrayList<PowerWhale> repairSolutionList(ArrayList<PowerWhale> solutionList)
	{
		for(int i = 0; i < solutionList.size(); i++) 
		{						
			solutionList.set(i, repairSolution(solutionList.get(i)));
		}
		
		return solutionList;
	}
}
