package CP_Algorithms;

//do not forget to remove //TBR


import java.util.ArrayList;
import java.util.Random;

import DatacenterSpec.Container;
import DatacenterSpec.PM;
import DatacenterSpec.PowerPM;
import ExpConfig.Result;
import WOA_Config.PowerWhale;
public class E_DCP {

	private ArrayList<Container> containerSpecList;			//list of all containers in experiment 
	private ArrayList<PowerPM> pmSpecList;					//list of all PMs in experiment
		
	private int NW;
	private int iterN;
	private double OLT = .8;								//default overloading threshold is set to 80%  
	private double scoreMark = .3;							//used for ranking each evaluation metric
	
	private double coePwr = - .5;
	private double coeUtil = .5;
	private double coeOLT = - .5;
	
	private Result optResult;
		
	public E_DCP(int NW, int iterN, ArrayList<Container> containerSpecList, ArrayList<PM> pmSpecList)
	{
		this.NW = NW/4;
		this.iterN = iterN/2;		
		
		this.containerSpecList = new ArrayList<Container>(containerSpecList);
		this.pmSpecList = this.copyPMlist_PowerPMlist(pmSpecList);			//assign normal PMs to PowerPMs
		
		
		this.optResult = new Result("E_DCP");
	}

	
	public E_DCP(int NW, int iterN, ArrayList<Container> containerSpecList, ArrayList<PM> pmSpecList, double OLT)
	{
		this(NW, iterN, containerSpecList, pmSpecList);
		this.OLT = OLT;
	}
	
	/**
	 * copy
	 * @param tmpPmSpecList
	 */
	private ArrayList<PowerPM> copyPMlist_PowerPMlist(ArrayList<PM> tmpPmSpecList)
	{
		ArrayList<PowerPM> tmpPowerPMSpecList = new ArrayList<PowerPM>();
		
		for(PM tmpPM: tmpPmSpecList)
		{
			tmpPowerPMSpecList.add(new PowerPM(tmpPM.getId(), tmpPM.getRam(), tmpPM.getMips()));
		}
		return tmpPowerPMSpecList;
	}

	public PowerWhale startAlgorithm() {
		// ***** steps in alg 1. DWO-CP algorithm **** //
				
		//step 1: initialization 
		//int iterN = 10;
		int it = 0;
		ArrayList<PowerWhale> solutionList = new ArrayList<PowerWhale> ();
		
		//step 2: construct a list of solutions 
		solutionList = this.intSolutionList();
		
		do {
		//step 3 - 7
			solutionList = updateSolutionList(solutionList);
		
		//implement fitness method -- utilization
		
		it++;
		}while(it<this.iterN);
				
		/*//TBR 
		System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
		+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: Counter of the loop in the update solution: " + this.loopCounter);/**/
		
		PowerWhale bestSolution = solutionList.get(findBestSolution(solutionList));
		
		//repair best solution by trying to migrate containers from oltPMs 
		//bestSolution = this.repairBestSolution(bestSolution);
		
		bestSolution = this.optimizeSolution(bestSolution);
		
		
		
		this.optResult.setContNum(this.countTotContainerSolution(bestSolution));
		this.optResult.setPower(bestSolution.getTotPowerConsumption());
		this.optResult.setPmNum(bestSolution.getPmList().size());
		this.optResult.setSolNum(this.NW);
		this.optResult.setSearchSpace(this.iterN);
		this.optResult.setIdlePmNumber(bestSolution.getIdlePmNumber());
		this.optResult.setAvgUtil(bestSolution.getAvgUtilLevel());
		this.optResult.setPMsOLT(bestSolution.getTotOverLoadedPMs(this.OLT));
		
		return bestSolution;
	}
	
	/**
	 * this is the new version of repair solution which aims at reassigning of containers between pms
	 * @param solution
	 * @return
	 */
	private PowerWhale optimizeSolution(PowerWhale solution) 
	{
		PowerWhale optSolution = new PowerWhale();
		ArrayList<PowerPM> pmList = solution.getPmList();
		ArrayList<PowerPM> OltPmList = new ArrayList<PowerPM>();
		ArrayList<Container> contMigrateList = new ArrayList<Container>();
		
		for(int i = 0; i < pmList.size(); i++)
		{
			PowerPM pm = pmList.get(i);
			ArrayList<Container> contList = new ArrayList<Container>(pm.getContainerList());

			for(Container contMigrate: contList)
			{
				pm.removeContainer(contMigrate);
				contMigrateList.add(contMigrate);
			}
			
			pmList.set(i, pm);
		}
			
		for(Container contMigrate: contMigrateList)
		{
			double oltGap = 0, curOltGap = 0;
			int migratePMindex = 0;
			PowerPM migratePM = null;
			
		//choose a pm to place contMigrate to
			for(int i = 0; i < pmList.size(); i++)
			{
				migratePM = pmList.get(i);
				
				if(!migratePM.canHost(contMigrate))
					continue;
				
				curOltGap = getOLTgap(migratePM, contMigrate.getMips(), this.OLT);
				
				if(curOltGap > oltGap)
				{
					oltGap = curOltGap;
					migratePMindex = i;
				}
			}

			migratePM = pmList.get(migratePMindex);
			migratePM.addContainer(contMigrate);
			pmList.set(migratePMindex, migratePM);
		}
			
		for(int i = 0; i < pmList.size(); i++)
		{
			if(pmList.get(i).getContainerList().size() == 0)
			{
				pmList.remove(i);
				i--;
			}
		}
		
		optSolution.setPmList(pmList);
		return optSolution;
	}
	
	private PowerWhale _optimizeSolution(PowerWhale solution) 
	{
		PowerWhale optSolution = new PowerWhale();
		ArrayList<PowerPM> pmList = solution.getPmList();
		ArrayList<PowerPM> OltPmList = new ArrayList<PowerPM>();
		ArrayList<Container> contMigrateList = new ArrayList<Container>();
		
		for(PowerPM pm: pmList)
		{
			if(this.underloadedAllocation(pm, 0, this.OLT))		//means this pm is OLT
				OltPmList.add(pm);
		}
		
		for(PowerPM oltPm: OltPmList)
		{
			ArrayList<Container> contList = oltPm.getContainerList();
			for(int i=0; i < contList.size(); i++ )
			{
				Container contMigrate = contList.get(i);
				contMigrateList.add(contMigrate);
				oltPm.removeContainer(contMigrate);
				
				if(!this.underloadedAllocation(oltPm, 0, this.OLT))	//means this pm is no OLT
				{
					int index = pmList.indexOf(oltPm);
					pmList.set(index, oltPm);
					break;
				}
			}
		}
			
		for(Container contMigrate: contMigrateList)
		{
		//choose a pm to place contMigrate to
			for(int i = 0; i < pmList.size(); i++)
			{
				PowerPM migratePM = pmList.get(i);
				if(this.underloadedAllocation(migratePM, contMigrate.getMips(), this.OLT))
				{
					migratePM.addContainer(contMigrate);
					pmList.set(i, migratePM);
					break;
				}
			}
		}
			
		
		
		optSolution.setPmList(pmList);
		return optSolution;
	}
	
	//this an old "optimize method
	private PowerWhale repairBestSolution(PowerWhale bs) 
	{
		PowerWhale repairedSolution = new PowerWhale();
		ArrayList<PowerPM> pmList = bs.getPmList();
		ArrayList<PowerPM> OltPmList = new ArrayList<PowerPM>();
		
		for(PowerPM pm: pmList)
		{
			if(this.underloadedAllocation(pm, 0, this.OLT))		//means this pm is OLT
				OltPmList.add(pm);
		}
		
		for(PowerPM oltPm: OltPmList)
		{
			double pmMIPSmargin = 0;
			Container contMigrate = new Container();
			
			ArrayList<Container> contList = oltPm.getContainerList();
			for(Container cont: contList)
			{
				if( (oltPm.getTotAllocatedMips() - cont.getMips())/oltPm.getMips() <= OLT )
				{
					if((oltPm.getTotAllocatedMips() - cont.getMips()) > pmMIPSmargin)
					{
						pmMIPSmargin = oltPm.getTotAllocatedMips() - cont.getMips();
						contMigrate = cont;
					}						
				}
			}
			
			//choose a pm to place contMigrate to
			for(int i = 0; i < pmList.size(); i++)
			{
				PowerPM migratePM = pmList.get(i);
				if(this.underloadedAllocation(migratePM, contMigrate.getMips(), this.OLT))
				{
					migratePM.addContainer(contMigrate);
					pmList.set(i, migratePM);
					
					//removing contMigrate from the oltPm
					i = pmList.indexOf(oltPm);
					oltPm.removeContainer(contMigrate);
					pmList.set(i, oltPm);
					
					break;
				}
			}
			
		}
		
		repairedSolution.setPmList(pmList);
		return repairedSolution;
	}

	private int countTotContainerSolution(PowerWhale solution) 
	{		
		ArrayList<PowerPM> pmList = solution.getPmList();
		int contCounter = 0;
		
		for(PowerPM pm: pmList)
		{
			contCounter += pm.getContainerList().size();
		}
		
		return contCounter;
	}
	
	/**
	 * initializes a single solution by placing containers randomly to PMs
	 * @param contList a list of containers to be placed on pmSpecList
	 * @param pmSpecList a list of PMs to host contList
	 * @return PowerWhale: a single solution of List of PMs hosting a list of containers 
	 */
	private PowerWhale intSingleSolution(ArrayList<Container> contList, ArrayList<PowerPM> pmSpecList)
	{
		PowerWhale singleSolution = new PowerWhale();		
		int contNo = contList.size();
		int pmNo = pmSpecList.size();
		
		Random random = new Random();
		
		//copy pmSpecList to pmlist of the solution
		for(int i=0; i < pmNo; i++)
		{
			PowerPM pm = new PowerPM(i, pmSpecList.get(i).getRam(), pmSpecList.get(i).getMips());
			singleSolution.addPM(pm);
		}
		
		for(int i=0; i < contNo; i++)
		{
			Container cont = contList.get(i);
			boolean contPlace = false;
			int pmIndex = 0;
			PowerPM tmpPm = null;
					
			while(!contPlace)
			{
				pmIndex = random.nextInt(pmNo);
				tmpPm = singleSolution.getPMbyIndex(pmIndex);
				
				if(tmpPm.canHost(cont))		//we can add util condition for future expansion 
				{
					tmpPm.addContainer(cont);
					contPlace = true;
				}
			}			
			
			
			singleSolution.setPMbyIndex(pmIndex, tmpPm);
		}
		
		return singleSolution;
	}

	private PowerWhale intBestSolution(ArrayList<Container> contList, ArrayList<PowerPM> pmSpecList) {
		PowerWhale bestSolution = new PowerWhale();		
		int contNo = contList.size();
		int pmNo = pmSpecList.size();
		
		int containerIndex = 0;			//used to keep track of all already placed containers
		for(int i=0; i < pmNo; i++)
		{
			PowerPM pm = new PowerPM(i, pmSpecList.get(i).getRam(), pmSpecList.get(i).getMips());
			
			for(; containerIndex < contNo; containerIndex++)
			{
				Container cont = contList.get(containerIndex);
				if(pm.canHost(cont) && this.underloadedAllocation(pm, cont.getMips(), this.OLT))
				{
					pm.addContainer(cont);
				}
				else
					break;
			}
			bestSolution.addPM(pm);
		}
		
		//TBR
		/*System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
				+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: "
				+ "power consumed best solution " + bestSolution.getTotPowerConsumption()
				+ ", number of running PMs: " + bestSolution.getPmList().size()
				+ ", idle pm number = " + bestSolution.getIdlePmNumber()); //*/
		
		return bestSolution;
	}
	
	private boolean underloadedAllocation(PowerPM pm, double contMips, double OLT)
	{
		boolean ret = false;
		if((pm.getTotAllocatedMips() + contMips)/pm.getMips() <= OLT)
			ret = true;
		return ret;
	}
	/**
	 * 
	 * @param pm
	 * @param contMips
	 * @param OLT
	 * @return calculate the gap if the container is allocated to PM, who much util level becomes
	 */
	private double getOLTgap(PowerPM pm, double contMips, double OLT)
	{
		double oltGap;
		oltGap = (pm.getTotAllocatedMips() + contMips)/pm.getMips();
		if(oltGap > OLT)
			oltGap = 0;
		return oltGap;
	}
	
	/**
	 * initializes a list of solutions, each solution is a whale of PMs hosting containers
	 * @return
	 */
	private ArrayList<PowerWhale> intSolutionList() {
		ArrayList<PowerWhale> solutionList = new ArrayList<PowerWhale>();			
		
		//*
		//initialize the best solution using first fit
		solutionList.add(this.removeIdlePmsInSingleSolution(this.intBestSolution(containerSpecList, pmSpecList)));
		
		for(int i=1; i < this.NW; i++)
		{
			PowerWhale singleSolution = new PowerWhale();
			singleSolution = this.intSingleSolution(this.containerSpecList, this.pmSpecList);
			singleSolution = this.removeIdlePmsInSingleSolution(singleSolution);
			solutionList.add(singleSolution);
		}
		/**/
		
		//testing initialize all solutions to the best solution 
		/*
		for(int i = 0; i < this.NW; i++)
		{
			solutionList.add(this.removeIdlePmsInSingleSolution(this.intBestSolution(containerSpecList, pmSpecList)));
		}
		/**/
		
		return solutionList;
	}
	
	private ArrayList<PowerWhale> updateSolutionList(ArrayList<PowerWhale> solutionList)
	{
		
//step 3: finding best solution 
		int bestSolutionIndex;
		PowerWhale bestSolution;
		
		bestSolutionIndex = findBestSolution(solutionList);
		bestSolution = solutionList.get(bestSolutionIndex);
		
//Extra: set the # of solutions to a random list from 1 to solutionList.size() 

		Random random = new Random();
		int randSolutionSize = Math.abs( random.nextInt(solutionList.size()) );
		
		if (randSolutionSize == 0)
			randSolutionSize = 1;
//End of this extra step		
		
		
//step 4: update each search agent i.e. whale solution 
		for(int r = 0; r < randSolutionSize; r++) 
		{			
//step 5: update the current solution 
			PowerWhale currentSolution = solutionList.get(r);
			
			
			//if(this.scoreSolution(bestSolution) < this.scoreSolution(currentSolution))
			if(this.compareSolutions(currentSolution, bestSolution))	//true means current solution is better than best solution
			{
				bestSolutionIndex = r;
				bestSolution = currentSolution;
			
				/*/TBU: change to performEval takes in consideration power, util and overloading
				System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
						+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: " + "we have a new best solution");/**/
				
				continue;
			}
				
			PowerWhale randomSolution = this.intSingleSolution(this.containerSpecList, this.pmSpecList);

			currentSolution = updateSingleSolution(currentSolution, bestSolution, randomSolution);
			currentSolution = this.removeIdlePmsInSingleSolution(currentSolution);
			
			solutionList.set(r, currentSolution);
		}
		
		return solutionList;
	}
	
	private int findBestSolution(ArrayList<PowerWhale> solutionList) {
		int bestSolutionIndex = 0;
		//double bestSolutionScore = this.scoreSolution(solutionList.get(0));
		
		for(int i=1; i < solutionList.size(); i++) {
			if(this.compareSolutions(solutionList.get(i), solutionList.get(bestSolutionIndex)))
			{
				bestSolutionIndex = i;
			}
		}
		return bestSolutionIndex;
	}
	
	private PowerWhale updateSingleSolution(PowerWhale currentSolution, PowerWhale bestSolution, PowerWhale randomSolution)
	{
		Random random = new Random();
		double rand;
		double a;
		double cf_1;
		double cf_2;
		double prob;
		double dir, dir_dash;
		int pmNo;
		
		a = random.nextDouble() * 2 ;
		rand = random.nextDouble();
		cf_1 = 2 * a * rand - a;	//in the WOA paper , cf_1 is called A
		cf_2 = 2 * rand;			//in the WOA papr, cd_2 is called C
		prob = random.nextDouble();
		
		ArrayList<Container> contList = new ArrayList<Container>();
		ArrayList<PowerPM> pmList = new ArrayList<PowerPM>();
		
		pmList = currentSolution.getPmList();
		pmNo = pmList.size();
		
		for(int pmIndex = 0; pmIndex < pmList.size(); pmIndex++)
		{
			PowerPM curPM = pmList.get(pmIndex);
			contList.addAll(curPM.getContainerList());
		}
		
		
		for(Container curCont: contList)
		{
			boolean migrateFalg = false;
			int tarPM_id, curPM_id, randPM_id, bsPM_id;
			
			curPM_id = currentSolution.getPMindexbyContainer(curCont);
			randPM_id = randomSolution.getPMindexbyContainer(curCont);
			bsPM_id = bestSolution.getPMindexbyContainer(curCont);
			
				
			//do {
				
				//a in the original WOA paper should be a double number decreasing from 2 to 0, for example 1.8, 1.6 .. etc, while in DWO paper a is integer
			
				if(prob < .5 && Math.abs(cf_1) < 1) {				//encircling Prey
						dir = Math.abs( cf_2 * (double) randPM_id - curPM_id);
						tarPM_id = (int) Math.ceil( (double) bsPM_id - cf_1 *  dir ) % pmNo;							
				}
				
				else if (prob < .5 &&  Math.abs(cf_1) >= 1){		//spiral move							
						dir = Math.abs( cf_2 * (double) randPM_id - curPM_id );
						tarPM_id = (int) Math.ceil( (double) randPM_id - cf_1 *  dir ) % pmNo ;							
				}
				else {												//spiral update
						double z = (random.nextDouble() * (1 - (-1))) + (-1);		//in the WOA paper, z is called l
						double b = 1;
						
						dir_dash = Math.abs( bsPM_id - curPM_id);
						tarPM_id = (int) Math.ceil( dir_dash * Math.exp(z * b) * Math.cos(2 * Math.PI * z) + (double) bsPM_id ) % pmNo;							
				}
				
				tarPM_id = Math.abs(tarPM_id);
				migrateFalg = currentSolution.migrateContainer(curPM_id, tarPM_id, curCont);
				
				if(migrateFalg == false)
				{
					a = random.nextDouble() * 2 ;
					rand = random.nextDouble();
					cf_1 = 2 * a * rand - a;	//in the WOA paper , cf_1 is called A
					cf_2 = 2 * rand;			//in the WOA papr, cd_2 is called C
					prob = random.nextDouble();
				}
				/*//TBR
				else
				{
					System.out.println("[" + new Object(){}.getClass().getEnclosingClass().getSimpleName()
							+ "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: " + "migrate is true");
				}/**/
			//}while(!migrateFalg);
		}
		
		return currentSolution;
	}
	
	public Result getOptResult()
	{
		return this.optResult;
	}
	
	private PowerWhale removeIdlePmsInSingleSolution(PowerWhale solution)
	{
		ArrayList<PowerPM> pmList = solution.getPmList();
		
		for(int i=0; i < pmList.size(); i++)
		{
			PowerPM pm = pmList.get(i);
			if(pm.getUtilization() == 0)
			{
				pmList.remove(i);
				i--;
			}
		}			
		
		solution.setPmList(pmList);
		return solution;
	}
	
	/**
	 * checks evaluation metrics: power consumption, # active PMs and overloading, score them
	 * @param currentSolution
	 * @param bestSolution
	 * @return true if the current solution's score > best solution's score
	 */
	private boolean compareSolutions(PowerWhale currentSolution, PowerWhale bestSolution)
	{
		boolean ret = false;
		
		if(currentSolution.getTotPowerConsumption() < bestSolution.getTotPowerConsumption())
			return true;
		
		double bsPwr = bestSolution.getTotPowerConsumption();
		double bsOLT = bestSolution.getTotOverLoadedPMs(this.OLT);
		double bsActivePMs = bestSolution.getActivePmNo();
		
		double score = 0;
		score = (currentSolution.getTotPowerConsumption() - bsPwr) / bsPwr;
		score += (currentSolution.getTotOverLoadedPMs(this.OLT) - bsOLT) / bsOLT;
		score += (currentSolution.getActivePmNo() - bsActivePMs) / bsActivePMs;
		
		if(score < 0)
			ret = true;
		
		return ret;
	}
	
	//old compare solution
	private boolean compareSolutions_old(PowerWhale currentSolution, PowerWhale bestSolution)
	{
		boolean ret = false;
		double scoreMark = this.scoreMark;
		double score_cr =0, score_bs = 0;
		
		if(currentSolution.getTotPowerConsumption() < bestSolution.getTotPowerConsumption())
			score_cr += scoreMark;
		else
			score_bs += scoreMark;
		
		if(currentSolution.getTotOverLoadedPMs(this.OLT) < bestSolution.getTotOverLoadedPMs(this.OLT))
			score_cr += scoreMark;
		else
			score_bs += scoreMark;
		/*
		if(currentSolution.getAvgUtilLevel() > bestSolution.getAvgUtilLevel())
			score_cr += scoreMark;
		else
			score_bs += scoreMark;/**/
		
		if(score_cr > score_bs)
			ret = true;
		
		return ret;
	}
	
	/**
	 * calculates the score of a solution based on this.coePwr * currentSolution.getTotPowerConsumption() + this.coeUtil * currentSolution.getAvgUtilLevel() + this.coeOLT * currentSolution.getTotOverLoadedPMs(this.OLT)
	 * @param currentSolution
	 * @return the score
	 */
	private double scoreSolution(PowerWhale currentSolution)
	{
		double score = 0;
		
		score = this.coePwr * currentSolution.getTotPowerConsumption() + this.coeUtil * currentSolution.getAvgUtilLevel() + this.coeOLT * currentSolution.getTotOverLoadedPMs(this.OLT); 
		
		return score;
	}
}
