package CP_Algorithms;

import java.util.ArrayList;
import java.util.Random;

import DatacenterSpec.Container;
import DatacenterSpec.PM;
import DatacenterSpec.VM;
import WOA_Config.Whale;

public class MF_CP {
	private ArrayList<Container> containerSpecList;
	private ArrayList<VM> vmSpecList;
	private ArrayList<PM> pmSpecList;
	
	private int l;
	private int v;
	private int p;
	private int NW;
	private int iterN;
	
	public MF_CP(int l, int v, int p, int NW, int iterN, ArrayList<Container> containerSpecList, ArrayList<VM> vmSpecList, ArrayList<PM> pmSpecList)
	{
		this.l = l;
		this.v = v;
		this.p = p;
		this.NW = NW;
		this.iterN = iterN;
		
		this.containerSpecList = new ArrayList<Container>(containerSpecList);
		this.vmSpecList = new ArrayList<VM>(vmSpecList);
		this.pmSpecList = new ArrayList<PM>(pmSpecList);
		
	}

	public Whale startAlgorithm() {
		// ***** steps in alg 1. DWO-CP algorithm **** //
				
		//step 1: initialization 
		//int iterN = 10;
		int it = 0;
		ArrayList<Whale> solutionMatrix;
		
		//step 2: construct 2 x l matrix
		solutionMatrix = int_whales(this.l, this.v, this.p, this.NW);
		solutionMatrix = repairSolutionMatrix(solutionMatrix);
		
		/*
		do {
		//step 3 - 7
		solutionMatrix = updateSolutionMatrix(solutionMatrix, this.v, this.p);
		
		//implement fitness method -- utilization
		
		it++;
		}while(it<this.iterN);/**/
		
		return solutionMatrix.get(findBestSolution(solutionMatrix));
		
	}
	
	/**
	 * initializes phase of whales positions
	 * @param l 	the number of containers
	 * @param v		the number of VMs
	 * @param p		the number of PMs
	 * @param nw 	the number of whales (solutions)
	 *  
	 */
	private ArrayList<Whale> int_whales(int l, int v, int p, int NW) {
		ArrayList<Whale> solutionMatrix = new ArrayList<Whale>();
		ArrayList<VM> vmList = new ArrayList<VM>();
		ArrayList<PM> pmList = new ArrayList<PM>();
		
		//allocate containers to vms based on FF
		for(int cont = 0; cont < l; cont++) {
			Container container = new Container(cont, containerSpecList.get(cont).getRam(), containerSpecList.get(cont).getMips());
			
			int vmIndex = this.getVmIndexForContainerInVmList(vmList, container);		
			
			if(vmIndex == -1) {		//means no suitable vm found in vmList
				if(vmList.size() >= vmSpecList.size()) {		//no suitalbe vm in the datacenter 
					System.out.println("[DCP.int_whales]: **** ERROR: aborting *** cannot find a suitable vm to accomodate container id = " 
				+ container.getId() + ", ram = " + container.getRam() + ", mips = " + container.getMips());
					System.exit(0);
				}
				
				vmIndex = vmList.size();
				VM vm = new VM(vmSpecList.get(vmIndex).getId(), vmSpecList.get(vmIndex).getRam(), vmSpecList.get(vmIndex).getMips());
				vm.addContainer(container);
				vmList.add(vm);
			}
			else {
				VM vm = new VM(vmList.get(vmIndex).getId(), vmList.get(vmIndex).getRam(), vmList.get(vmIndex).getMips());
				ArrayList<Container> containerList = new ArrayList<Container>(vmList.get(vmIndex).getContainerList()); 
				containerList.add(container);
				vm.setContainerList(containerList);
				vmList.set(vmIndex, vm);
			}
		}

		//assign pms for vms 
		for (int i=0; i < vmList.size(); i++) {
			VM vm = new VM(vmList.get(i).getId(), vmList.get(i).getRam(), vmList.get(i).getMips());
			
			int pmIndex = getPmIndexForVmInPmList(pmList, vm);
			
			if(pmIndex == -1) {		//means no suitable pm to host a vm found in pmList
				if(pmList.size()>= pmSpecList.size()) {		//no suitalbe vm in the datacenter 
					System.out.println("[DCP.int_whales]: **** ERROR: aborting *** cannot find a suitable pm to accomodate vm id = " 
				+ vm.getId() + ", ram = " + vm.getRam() + ", mips = " + vm.getMips());
					System.exit(0);
				}
				
				pmIndex = pmList.size();
				PM pm = new PM(pmSpecList.get(pmIndex).getId(), pmSpecList.get(pmIndex).getRam(), pmSpecList.get(pmIndex).getMips());
				pm.addVm(vm);
				pmList.add(pm);
			}
			else {
				PM pm = new PM(pmList.get(pmIndex).getId(), pmList.get(pmIndex).getRam(), pmList.get(pmIndex).getMips());
				ArrayList<VM> pmVmList = new ArrayList<VM>(pmList.get(pmIndex).getVmList());
				pmVmList.add(vm);
				pm.setVmList(pmVmList);
				pmList.add(pm);
			}
		}
		/* only one solution
		//for late, to set PMs, set for every wahle "solution", its containers, vms and pms
		for(int i=0; i < NW-1; i++)
		{
			Whale w = new Whale(l);
			w.setRandomSolution(v,p);
			solutionMatrix.add(w);
		}/**/

		int vm_id = -1, pm_id = -1;
		VM vm = null;
		PM pm = null; 
		Whale w = new Whale(l);
		
		for(int i=0; i < l; i++) {
			for(VM tmpVm: vmList) {
				if(getIndexForIDinContainerList(tmpVm.getContainerList(), i) != -1) {
					vm = tmpVm;
					vm_id = vm.getId();
					break;
				}
			}
			for(PM tmpPm:pmList) {
				if(getIndexForIDinVmList(tmpPm.getVmList(), vm_id) != -1) {
					pm = tmpPm;
					pm_id = pm.getId();
					break;
				}
			}
			w.addRecord(vm_id, pm_id);
		}
		solutionMatrix.add(w);
		
		return solutionMatrix;
	}
	
	private int getVmIndexForContainerInVmList(ArrayList<VM> vmList, Container cont) {
		for(int i=0; i < vmList.size(); i++) {
			if(vmList.get(i).canHost(cont)) {
				return i;
			}
		}
		return -1;
	}

	
	private int getPmIndexForVmInPmList(ArrayList<PM> pmList, VM vm) {
		for(int i=0; i < pmList.size(); i++) {
			if(pmList.get(i).canHost(vm)) {
				return i;
			}
		}
		return -1;
	}
	
	private ArrayList<Whale> repairSolutionMatrix(ArrayList<Whale> solutionMatrix){
		for(int i = 0; i < solutionMatrix.size(); i++) 
		{						
			solutionMatrix.set(i, repairCurrentSolution(solutionMatrix.get(i)));
		}
		
		return solutionMatrix;
	}
	
	private ArrayList<Whale> updateSolutionMatrix(ArrayList<Whale> solutionMatrix, int v, int p)
	{
		Random random = new Random();
		double rand;
		double a;
		double cf_1;
		double cf_2;
		double prob;
		
//step 3: finding best solution 
		int bestSolutionIndex;
		Whale bestSolution;
		
//step 4: update each search agent i.e. whale solution 
		for(int r = 0; r < solutionMatrix.size(); r++) {
			
			bestSolutionIndex = findBestSolution(solutionMatrix);
			bestSolution = solutionMatrix.get(bestSolutionIndex);
			
			if(r == bestSolutionIndex)
				continue;

			rand = random.nextDouble();
			
			//a in the original WOA paper should be a double number decreasing from 2 to 0, for example 1.8, 1.6 .. etc, while in DWO paper a is integer 
			a = random.nextDouble() * 2 ;
			cf_1 = 2 * a * rand - a;	//in the WOA paper , cf_1 is called A
			cf_2 = 2 * rand;			//in the WOA papr, cd_2 is called C
			prob = random.nextDouble();
			
//step 5: update other solutions 
			Whale currentSolution = solutionMatrix.get(r);
			Whale randomSolution = new Whale(currentSolution.getSolutionSize());
			randomSolution.setRandomSolution(v,p);
			//randomSolution = repairCurrentSolution(randomSolution);	//according to both papers WOA and DWO_CP not mentioning of correcting the random solution 
			
			int vm_id, pm_id;
			double dir, dir_dash;
						
			if(prob < .5 && Math.abs(cf_1) < 1) {			//encircling Prey
				for(int l_index = 0; l_index < currentSolution.getSolutionSize(); l_index++) {
					
					//calculating vm for container lth
					vm_id = currentSolution.getVM_id(l_index);
					dir = Math.abs( cf_2 * (double) randomSolution.getVM_id(l_index) - vm_id);
					vm_id = (int) Math.ceil( (double) bestSolution.getVM_id(l_index) - cf_1 *  dir ) % (v+1);

					//calculating pm for container lth
					pm_id = currentSolution.getPM_id(l_index);
					dir = Math.abs( cf_2 * (double) randomSolution.getPM_id(l_index) - pm_id);
					pm_id = (int) Math.ceil( (double) bestSolution.getPM_id(l_index) - cf_1 *  dir ) % (p+1);
					
					//updating vm & vm for container lth
					currentSolution.setVM_id(l_index, vm_id);
					currentSolution.setPM_id(l_index, pm_id);
				}
			}
			else if (prob < .5 &&  Math.abs(cf_1) >= 1){		//spiral move
				for(int l_index = 0; l_index < currentSolution.getSolutionSize(); l_index++) {
					
					//calculating vm for container lth
					vm_id = currentSolution.getVM_id(l_index);
					dir = Math.abs( cf_2 * (double) randomSolution.getVM_id(l_index) - vm_id);
					vm_id = (int) Math.ceil( (double) randomSolution.getVM_id(l_index) - cf_1 *  dir ) % (v+1);


					//calculating pm for container lth
					pm_id = currentSolution.getPM_id(l_index);
					dir = Math.abs( cf_2 * (double) randomSolution.getPM_id(l_index) - pm_id);
					pm_id = (int) Math.ceil( (double) randomSolution.getPM_id(l_index) - cf_1 *  dir ) % (p+1);
					
					//updating vm & vm for container lth
					currentSolution.setVM_id(l_index, vm_id);
					currentSolution.setPM_id(l_index,pm_id);
				}
			}
			else {									//spiral update
				for(int l_index = 0; l_index < currentSolution.getSolutionSize(); l_index++) {
					double z = (random.nextDouble() * (1 - (-1))) + (-1);		//in the WOA paper, z is called l
					double b = 1;
					
					//calculating vm for container lth
					vm_id = currentSolution.getVM_id(l_index);
					dir_dash = Math.abs( bestSolution.getVM_id(l_index) - vm_id);
					vm_id = (int) Math.ceil( dir_dash * Math.log(z * b) * Math.cos(2 * Math.PI * z) + (double) bestSolution.getVM_id(l_index) ) % (v+1);


					//calculating pm for container lth
					pm_id = currentSolution.getPM_id(l_index);
					dir_dash = Math.abs( bestSolution.getPM_id(l_index) - pm_id);
					pm_id = (int) Math.ceil( dir_dash * Math.exp(z * b) * Math.cos(2 * Math.PI * z) + (double) bestSolution.getPM_id(l_index) ) % (p+1);
					
					//updating vm & vm for container lth
					currentSolution.setVM_id(l_index, vm_id);
					currentSolution.setPM_id(l_index, pm_id);
				}				
			}
			
//step 6: repair solution(s)
			currentSolution = repairCurrentSolution(currentSolution);
			solutionMatrix.set(r, currentSolution);
//step 7: continue the loop as long r < NW
		}
		
		return solutionMatrix;
	}
	
	private int findBestSolution(ArrayList<Whale> solutionMatrix) {
		int minIndex = 0;
		double powerConsumption = solutionMatrix.get(0).getTotPowerConsumption();
		
		for(int i=1; i < solutionMatrix.size(); i++) {
			double tmpPower = solutionMatrix.get(i).getTotPowerConsumption();
			
			if(tmpPower < powerConsumption) {
				minIndex = i;
				powerConsumption = tmpPower;
			}
			else if (tmpPower == powerConsumption) {
				if (solutionMatrix.get(i).getVmTotalUniqueNumber() < solutionMatrix.get(minIndex).getVmTotalUniqueNumber()) {
					minIndex = i;
				}
			}
		}
		return minIndex;
	}
	
	private int findBestSolution_byPMnumbers(ArrayList<Whale> solutionMatrix) {
		int minIndex = 0;
		int minPmTotalNumber = solutionMatrix.get(0).getPmTotalUniqueNumber();
		
		for(int i=1; i < solutionMatrix.size(); i++) {
			int currentPmTotalNumber = solutionMatrix.get(i).getPmTotalUniqueNumber();
			
			if(currentPmTotalNumber < minPmTotalNumber) {
				minIndex = i;
				minPmTotalNumber = currentPmTotalNumber;
			}
			else if (currentPmTotalNumber == minPmTotalNumber) {
				if (solutionMatrix.get(i).getVmTotalUniqueNumber() < solutionMatrix.get(minIndex).getVmTotalUniqueNumber()) {
					minIndex = i;
				}
			}
		}
		return minIndex;
	}
	
	/**
	 * returns the index of container_id
	 * @param vmList
	 * @param vm_id
	 * @return		returns the index of container_id if found or -1 if not found
	 */
	private int getIndexForIDinContainerList(ArrayList<Container> containerList, int container_id) {
		for(int i=0; i < containerList.size(); i++) {
			Container container = containerList.get(i);
			if(container.getId() == container_id)
				return i;
		}
		return -1;
	}
	
	/**
	 * returns the index of vm_id
	 * @param vmList
	 * @param vm_id
	 * @return		returns the index of vm_id if found or -1 if not found
	 */
	private int getIndexForIDinVmList(ArrayList<VM> vmList, int vm_id) {
		for(int i=0; i < vmList.size(); i++) {
			VM vm = vmList.get(i);
			if(vm.getId() == vm_id)
				return i;
		}
		return -1;
	}
	
	/**
	 * returns the index of pm_id
	 * @param pmList
	 * @param pm_id
	 * @return		returns the index of pm_id if found or -1 if not found
	 */
	private int getIndexForIDinPmList(ArrayList<PM> pmList, int pm_id) {
		for(int i=0; i < pmList.size(); i++) {
			PM pm = pmList.get(i);
			if(pm.getId() == pm_id)
				return i;
		}
		return -1;
	}
	
	/**
	 * repairs a solution by migrate containers from overloaded vms and migrate vms from overloaded pms
	 * @param currentSolution
	 * @return
	 */
	private Whale repairCurrentSolution(Whale w){
		Whale currentSolution = copySolution(w);
		
		ArrayList <Container>  tmpContainerList = new ArrayList<Container>();
		ArrayList<Container> migratedContainerList = new ArrayList<Container>();
		
		ArrayList<VM> tmpVmList = new ArrayList<VM>();
		ArrayList<VM> idleVmList = new ArrayList<VM>(vmSpecList);		//contains idle vms, i.e. does not host any containers
		ArrayList<VM> activeVmList = new ArrayList<VM>();
		ArrayList<VM> overloadedVmList = new ArrayList<VM>();
		ArrayList<VM> migratedVmList = new ArrayList<VM>();

		ArrayList<PM> idlePmList = new ArrayList<PM>(pmSpecList);		//contains idle pms, i.e. does not host any vms
		ArrayList<PM> activePmList = new ArrayList<PM>();
		ArrayList<PM> overloadedPmList = new ArrayList<PM>();
		
		//clear the lists from copy by reference problem 
		for(int i=0; i< vmSpecList.size(); i++) {
			vmSpecList.get(i).setContainerList(new ArrayList<Container>());
		}
		for(int i=0; i< pmSpecList.size(); i++) {
			pmSpecList.get(i).setVmList(new ArrayList<VM>());
		}

		//container assigned to different vm needs to be fixed, vm allocated to different hosts needs to be fixed,
		currentSolution = correctVmsToPmsInSolution(currentSolution);

		int vm_id;
		int pm_id;
		int index;

		//loop getting column info in each iteration 
		for(int col = 0; col < currentSolution.getSolutionSize(); col++) {
			//add active vm to the active list
			int container_id = col;
			Container container = new Container(container_id, containerSpecList.get(container_id).getRam(), containerSpecList.get(container_id).getMips());
			
			vm_id = currentSolution.getVM_id(col);
			index = vm_id - 1;		//can be done using getIndexForIDinVmList
			VM vm = new VM(vm_id, vmSpecList.get(index).getRam(), vmSpecList.get(index).getMips());
			
			index = getIndexForIDinVmList(activeVmList, vm_id);
			
			if(index != -1) {		//i.e. vm is alreay in the active list
				ArrayList<Container> containerList = new ArrayList<Container>(activeVmList.get(index).getContainerList()); //instead of //vm = activeVmList.get(index);
				containerList.add(container);
				vm.setContainerList(containerList);
				activeVmList.set(index, vm);
			}
			else {
				vm.addContainer(container);
				activeVmList.add(vm);
				
				index = getIndexForIDinVmList(idleVmList, vm.getId());
				idleVmList.remove(index);
			}			
			//end adding vm
			
			//add active pm to the active list
			pm_id = currentSolution.getPM_id(col);
			index = pm_id - 1;		//since pm id starts with 1
			
			PM pm = new PM(pm_id, pmSpecList.get(index).getRam(), pmSpecList.get(index).getMips());
						
			index = getIndexForIDinPmList(activePmList, pm_id);
			
			if(index != -1) {		//this pm is already placed in the active pm list
				ArrayList<VM> vmList = new ArrayList<VM>(activePmList.get(index).getVmList());
				pm.setVmList(vmList);		//instead of pm = activePmList.get(index);
				if(getIndexForIDinVmList(pm.getVmList(), vm.getId()) == -1) {		//if this vm is not already placed on the pm
					pm.addVm(vm);
				}
				activePmList.set(index, pm);
			}
			else {
				pm.addVm(vm);
				activePmList.add(pm);
				
				index = getIndexForIDinPmList(idlePmList, pm.getId());
				idlePmList.remove(index);
			}
			//end adding pm
		}
		
//fix the constraints according to Eqs 3-6, which calculate overloaded vms and pms
		
		for(int i=0; i < activeVmList.size(); i++) {
			VM vm = activeVmList.get(i);
			if(vm.isOverloaded()) {
				overloadedVmList.add(vm);
			}			
		}
		
		for(int i=0; i < activePmList.size(); i++) {
			PM pm = activePmList.get(i);
			if(pm.isOverloaded()) {		//true means this pm is overloaded
				overloadedPmList.add(pm);
			}
		}

		//set a list of containers to be migrated from an overloaded vm
		for(int i=0; i < overloadedVmList.size(); i++) {
			VM vm = overloadedVmList.get(i);
			while(vm.isOverloaded()) 
			{
				tmpContainerList = new ArrayList<Container>(vm.getContainerList());
				Container migCont = new Container();
				double cbv = Double.MAX_VALUE, tmpCbv;
				for(int j=0; j < tmpContainerList.size(); j++) {
					tmpCbv = Math.abs( ((vm.getMips() - tmpContainerList.get(j).getMips())/vm.getMips()) - ((vm.getRam() - tmpContainerList.get(j).getRam())/vm.getRam()) );	//eq. 19
					if(tmpCbv < cbv) {																																			//eq. 20
						migCont = tmpContainerList.get(j);
						cbv = tmpCbv;
					}
				}
				migratedContainerList.add(migCont); 
				
				index = getIndexForIDinContainerList(tmpContainerList, migCont.getId());
				tmpContainerList.remove(index);
				vm.setContainerList(tmpContainerList);
			}
			index = getIndexForIDinVmList(activeVmList, vm.getId());
			activeVmList.set(index, vm);			//updating the vm with the new containerlist that was on it
		}
		//finish 
				
		//set a list of vms to be migrated from an overloaded pm
		for(int i=0; i < overloadedPmList.size(); i++) {
			PM pm = overloadedPmList.get(i);
			while(pm.isOverloaded()) {
				tmpVmList = new ArrayList<VM>(pm.getVmList());
				VM migVm = new VM();
				double vmbv = Double.MAX_VALUE, tmpVmbv;
				for(int j=0; j < tmpVmList.size(); j++) {
					tmpVmbv = Math.abs( ((pm.getMips() - tmpVmList.get(j).getMips())/pm.getMips()) - ((pm.getRam() - tmpVmList.get(j).getRam())/pm.getRam()) );				//eq 21
					if(tmpVmbv < vmbv) {																																	//eq. 22
						migVm = tmpVmList.get(j);
						vmbv = tmpVmbv;
					}
				}
				migratedVmList.add(migVm); 
				
				index = getIndexForIDinVmList(tmpVmList, migVm.getId());
				tmpVmList.remove(index);
				pm.setVmList(tmpVmList);
			}
			index = getIndexForIDinPmList(activePmList, pm.getId());
			activePmList.set(index, pm);			//updating the vm with the new containerlist that was on it
		}
		
		//finish	
		
		//select a suitable vm for each container
		for(Container cont: migratedContainerList) {
			double dvmbv = Double.MAX_VALUE, tmpDvmbv;
			VM vm = new VM();
			index = -1;
			for(int i=0; i < activeVmList.size(); i++) {
				vm = activeVmList.get(i);
				if(vm.canHost(cont)) {
					tmpDvmbv = Math.abs( ((vm.getMips() + cont.getMips())/vm.getMips()) - ((vm.getRam() + cont.getRam())/vm.getRam()) );	//eq. 23					
					if(tmpDvmbv < dvmbv) {																									//eq. 24
						index = i;
						dvmbv = tmpDvmbv;
					}
				}
			}
			
			if(index == -1) {		//if there is no vm amongst active vms which can accommodate this container
				if(idleVmList.size() > 0) {	//there is at least one vm that can accommodate this container
					vm = idleVmList.remove(0);
					activeVmList.add(vm);
					migratedVmList.add(vm);		//in order to find suitable pm to host this newly added vm
					index  = activeVmList.size() - 1;
				}
				else {
					System.out.println("**** ERROR:aborting *** cannot find a suitable vm to accomodate container id = " + cont.getId() + ", ram = " + cont.getRam() + ", mips = " + cont.getMips());
					System.exit(0);
				}
			}
			
			vm = activeVmList.get(index);
			tmpContainerList = new ArrayList<Container>(vm.getContainerList()); //to copy values of arraylists not references 
			tmpContainerList.add(cont);
			vm.setContainerList(tmpContainerList);
			activeVmList.set(index, vm);
		}
		//finish 

		//select suitable pm for each vm
		for(VM vm: migratedVmList) {
			double pmbv = Double.MAX_VALUE, tmpPmbv;
			PM pm = new PM();
			index = -1;
			for(int i=0; i < activePmList.size(); i++) {
				pm = activePmList.get(i);
				if(pm.canHost(vm)) {
					tmpPmbv = Math.abs( ((pm.getMips() + vm.getMips())/pm.getMips()) - ((pm.getRam() + vm.getRam())/pm.getRam()) );		//eq. 25					
					if(tmpPmbv < pmbv) {																								//eq. 24
						index = i;
						pmbv = tmpPmbv;
					}
				}
			}
			if(index != -1) {
				pm = activePmList.get(index);
				tmpVmList = new ArrayList<VM>(pm.getVmList());		//copy values rather than references 
				if(!pm.containVM(vm.getId())) {		//update if the vm is not already hosted to this pm
					tmpVmList.add(vm);
					pm.setVmList(tmpVmList);
					activePmList.set(index, pm);
				}
			}
			else {		//if there is no pm amongst active pms which can accommodate this vm
				if(idlePmList.size() > 0) { 
					pm = idlePmList.remove(0);
					pm.addVm(vm);
					activePmList.add(pm);
				}
				else {
					System.out.println("**** ERROR:aborting *** cannot find a suitable pm to accomodate vm id = " + vm.getId() + ", ram = " + vm.getRam() + ", mips = " + vm.getMips());
					System.exit(0);
				}
			}
		}
		
		vm_id = pm_id = -1;
		VM vm = null;
		PM pm = null; 
		
		for(int i=0; i < currentSolution.getSolutionSize(); i++) {
			for(VM tmpVm: activeVmList) {
				if(getIndexForIDinContainerList(tmpVm.getContainerList(), i) != -1) {
					vm = tmpVm;
					vm_id = vm.getId();
					break;
				}
			}
			for(PM tmpPm:activePmList) {
				if(getIndexForIDinVmList(tmpPm.getVmList(), vm_id) != -1) {
					pm = tmpPm;
					pm_id = pm.getId();
					break;
				}
			}
			currentSolution.setVM(i, vm);
			currentSolution.setPM(i, pm);
		}
		
		return currentSolution;
	}
	
	/**
	 * corrects the placement of a vm to multiple pms by placing the same vm to the same pm, the pm is selected by the first order 
	 * @param solution
	 * @return the corrected solution 
	 */
	private Whale correctVmsToPmsInSolution(Whale w) {
		Whale solution = new Whale(w.getSolutionSize()); 		//to avoid call by reference
		solution = copySolution(w); 								//to avoid call by reference
		for(int i = 0 ; i < solution.getSolutionSize(); i++) {
			int vm_id = solution.getVM_id(i);
			int pm_id = solution.getPM_id(i);
			
			for(int j = i; j < solution.getSolutionSize(); j++) {
				if(vm_id == solution.getVM_id(j))
					solution.setPM_id(j, pm_id);
			}
		}
		return solution;
	}

	private Whale copySolution(Whale solution) {
		Whale w = new Whale(solution.getSolutionSize());

		for(int i=0; i < w.getSolutionSize(); i++) 
		{
			w.addRecord(solution.getVM_id(i), solution.getPM_id(i));
		}
		return w;
	}

}
