package DatacenterSpec;

import java.util.ArrayList;

public class PM {
	private int id;
	private double ram;
	private double mips;
	private double powerIdle;
	private double powerMax;
	private ArrayList<VM> vmList;
	
	public PM()
	{
		vmList = new ArrayList<VM>();
	}
	
	public PM(int id, double ram, double mips)
	{
		this.setId(id);
		this.setRam(ram);
		this.setMips(mips);
		
		//defualt param

		this.powerMax = 300;
		this.powerIdle = this.powerMax * 0.6;
		
		vmList = new ArrayList<VM>();
	}

	public void setId(int id) {
		this.id = id;
	}
	
	public int getId() {
		return this.id;
	}

	public void setRam(double ram)
	{
		this.ram = ram;
	}
	
	public double getRam()
	{
		return this.ram;
	}
	
	public void setMips(double mips)
	{
		this.mips = mips;
	}
	
	public double getMips() 
	{
		return this.mips;
	}
	
	public void addVm(VM vm)
	{
		this.vmList.add(vm);
	}
	
	public ArrayList<VM> getVmList()
	{
		return this.vmList;
	}
	
	public void setPowerIdle(double pwrIdle) {
		this.powerIdle = powerIdle;
	}
	
	public double getPowerIdle() {
		return this.powerIdle;
	}
	
	public void setPowerMax(double powerMax) {
		this.powerMax = powerMax;
	}
	
	public double getPowerMax()
	{
		return this.powerMax;
	}
	/**
	 * returns true if the pm is overloaded or false otherwise
	 * @return
	 */
	public boolean isOverloaded() {
		boolean ret = false;

		if(this.getRam() < this.getTotAllocatedRam() || this.getMips() < this.getTotAllocatedMips()) {
			ret = true;
		}
		return ret;
	}
	public void setVmList(ArrayList<VM> vmList) {
		this.vmList =  new ArrayList<VM>(vmList);
	}
	/**
	 * returns the total ram that is allocated to containers that are hosted to this vm
	 * @return
	 */
	public double getTotAllocatedRam()
	{
		double vmTot_ram = 0;
		
		for(int i=0; i < this.getVmList().size(); i++) {
			vmTot_ram += this.getVmList().get(i).getRam();		
		}
		return vmTot_ram;
	}
	/**
	 * returns the total mips that is allocated to containers that are hosted to this vm
	 * @return
	 */
	public double getTotAllocatedMips()
	{
		double vmTot_mips = 0;
		
		for(int i=0; i < this.getVmList().size(); i++) {
			vmTot_mips += this.getVmList().get(i).getMips();		
		}
		return vmTot_mips;
	}
	/**
	 * returns the free ram out of all reserved ram to hosted containers 
	 * @return
	 */
	public double getAvailableRam() {
		return this.getRam() - this.getTotAllocatedRam();
	}
	/**
	 * returns the free mips out of all reserved mips to hosted containers 
	 * @return
	 */
	public double getAvailableMips() {
		return this.getMips() - this.getTotAllocatedMips();
	}
	
	public boolean canHost(VM vm) {
		if(this.getAvailableRam() < vm.getRam() || this.getAvailableMips() < vm.getMips())
			return false;
		else
			return true;
	}
	/**
	 * returns true if this pm already hosts the vm with vm_id
	 * @param vm_id
	 * @return
	 */
	public boolean containVM(int vm_id) {
		for(VM vm:this.getVmList()) {
			if (vm.getId() == vm_id)
				return true;
		}
		return false;
	}
	
	public double getPowerConsumption()
	{
		if(this.getVmList().size() ==0)
			return 0;
		
		/*if(this.getUtilization() == 0)
			return this.getUtilization();*/
		
		return cal_linearPower();		//return linear power model
		//return cal_nonLinearPower();	//return non linear power model 
	}
	
	protected double cal_linearPower()
	{
		return this.getPowerIdle() + (this.powerMax - this.powerIdle) * this.getUtilization();		
	}
	
	/**
	 * calculated based on the model proposed by [Liang2014] and reference by [Zhang2020]
	 * @return
	 */
	protected double cal_nonLinearPower()
	{
		double powerConsumption = 0;
		double usedCpu = this.getTotAllocatedMips() / this.getMips();
		double usedMem = this.getTotAllocatedRam() / this.getRam();
		
		powerConsumption = 155.0537 + (375.855 * usedCpu) - (401.0088 * usedCpu * usedCpu) + (164.4327 * usedCpu * usedCpu * usedCpu)
									- (30.6192 * usedMem) + (41.8946 * usedMem * usedMem) - (19.8122 * usedMem * usedMem * usedMem);
				
		return powerConsumption;
	}
	public double getUtilization()
	{
		return this.getTotAllocatedMips()/this.getMips();
	}
}
