package DatacenterSpec;

import java.util.ArrayList;

public class PowerPM extends PM
{

	private ArrayList<Container> containerList;
	
	public PowerPM(int id, double ram, double mips)
	{
		super(id, ram, mips);
		containerList = new ArrayList<Container>();		
	}
	
	public PowerPM()
	{
		super();
		containerList = new ArrayList<Container>();		
	}
	
	public void addContainer(Container container)
	{
		this.containerList.add(container);
	}
	
	public void removeContainer(Container container)
	{
		this.containerList.remove(container);
	}
	
	public ArrayList<Container> getContainerList()
	{
		return this.containerList;
	}
	
	public void setContainerList(ArrayList<Container> containerList) {
		this.containerList = new ArrayList<Container>(containerList);
	}
	
	@Override
	public boolean isOverloaded()
	{
		boolean ret = false;

		if(this.getRam() < this.getTotAllocatedRam() || this.getMips() < this.getTotAllocatedMips()) {
			ret = true;
		}
		
		return ret;
	}
	
	/**
	 * returns the total ram that is allocated to containers that are hosted to this pm
	 * @return
	 */
	@Override
	public double getTotAllocatedRam()
	{
		double containerTot_ram = 0;
		
		for(int i=0; i < this.getContainerList().size(); i++) {
			containerTot_ram += this.getContainerList().get(i).getRam();		
		}
		return containerTot_ram;
	}
	
	/**
	 * returns the total mips that is allocated to containers that are hosted to this vm
	 * @return
	 */
	@Override
	public double getTotAllocatedMips()
	{
		double containerTot_mips = 0;
		
		for(int i=0; i < this.getContainerList().size(); i++) {
			containerTot_mips += this.getContainerList().get(i).getMips();		
		}
		return containerTot_mips;
	}
	
	/**
	 * returns the free ram out of all reserved ram to hosted containers 
	 * @return
	 */
	@Override
	public double getAvailableRam() {
		return this.getRam() - this.getTotAllocatedRam();
	}
	
	/**
	 * returns the free mips out of all reserved mips to hosted containers 
	 * @return
	 */
	@Override
	public double getAvailableMips() {
		return this.getMips() - this.getTotAllocatedMips();
	}
	
	public boolean canHost(Container c) {
		if(this.getAvailableRam() < c.getRam() || this.getAvailableMips() < c.getMips())
			return false;
		else
			return true;
	}
	
	/**
	 * returns the utilization level which is getTotAllocatedMips()/getMips()
	 * @return the utilization level
	 */
	@Override
	public double getUtilization() {
		return this.getTotAllocatedMips()/this.getMips();
	}

	//*
	@Override
	public double getPowerConsumption()
	{
		if(this.containerList.size() == 0)
			return 0;

		//System.out.println("testing PowerPM.getPowerConsumoption");
		return cal_linearPower();		//return linear power model
		//return cal_nonLinearPower();	//return non linear power model 
	}
	//*/

}