package DatacenterSpec;

import java.util.ArrayList;

public class VM {
	private int id;
	private double ram;
	private double mips;
	private ArrayList<Container> containerList;
	
	public VM()
	{
		containerList = new ArrayList<Container>();
	}
	
	public VM(int id, double ram, double mips)
	{
		this.setId(id);
		this.setRam(ram);
		this.setMips(mips);
		containerList = new ArrayList<Container>();

	}
	
	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return this.id;
	}
	
	public void setRam(double ram)
	{
		this.ram = ram;
	}
	
	public double getRam()
	{
		return this.ram;
	}
	
	public void setMips(double mips)
	{
		this.mips = mips;
	}
	
	public double getMips() 
	{
		return this.mips;
	}
	
	public void addContainer(Container container)
	{
		this.containerList.add(container);
	}
	
	public ArrayList<Container> getContainerList()
	{
		return this.containerList;
	}
	public void setContainerList(ArrayList<Container> containerList) {
		this.containerList = new ArrayList<Container>(containerList);
	}
	public boolean isOverloaded()
	{
		boolean ret = false;

		if(this.getRam() < this.getTotAllocatedRam() || this.getMips() < this.getTotAllocatedMips()) {
			ret = true;
		}
		
		return ret;
	}
	/**
	 * returns the total ram that is allocated to containers that are hosted to this vm
	 * @return
	 */
	public double getTotAllocatedRam()
	{
		double containerTot_ram = 0;
		
		for(int i=0; i < this.getContainerList().size(); i++) {
			containerTot_ram += this.getContainerList().get(i).getRam();		
		}
		return containerTot_ram;
	}
	/**
	 * returns the total mips that is allocated to containers that are hosted to this vm
	 * @return
	 */
	public double getTotAllocatedMips()
	{
		double containerTot_mips = 0;
		
		for(int i=0; i < this.getContainerList().size(); i++) {
			containerTot_mips += this.getContainerList().get(i).getMips();		
		}
		return containerTot_mips;
	}
	/**
	 * returns the free ram out of all reserved ram to hosted containers 
	 * @return
	 */
	public double getAvailableRam() {
		return this.getRam() - this.getTotAllocatedRam();
	}
	/**
	 * returns the free mips out of all reserved mips to hosted containers 
	 * @return
	 */
	public double getAvailableMips() {
		return this.getMips() - this.getTotAllocatedMips();
	}
	
	public boolean canHost(Container c) {
		if(this.getAvailableRam() < c.getRam() || this.getAvailableMips() < c.getMips())
			return false;
		else
			return true;
	}
	/**
	 * returns the utilization level which is getTotAllocatedMips()/getMips()
	 * @return the utilization level
	 */
	public double getUtilzation() {
		return this.getTotAllocatedMips()/this.getMips();
	}
}
