package ExpConfig;

import java.util.ArrayList;
import java.util.Random;

import DatacenterSpec.Container;
import DatacenterSpec.PM;
import DatacenterSpec.VM;

/**
 * class represents several pms taken from SPECpower 2008 Benchmarks, http: https://www.spec.org/power_ssj2008/results/res2022q1/
 * @author abdulelah
 *
 */
public class Servers {
	private ArrayList<VM> vmList;
	private ArrayList<PM> serverList;
	
	public Servers() {
		this.vmList = new ArrayList<VM>();
		this.setVmList();
		
		this.serverList = new ArrayList<PM>();
		this.setServers();
	}
	/**
	 * sets six types of vm instances taken from the paper by Khan2019 in mendeley representing Amazon
	 */
	public void setVmList() {
		int vm_id = 0;
		double ram, mips;
		
		//t2.nano
		ram = 1024 * 0.5;
		mips = 1024 * 1;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
		
		//t1.micro
		ram = 1024 * 0.613;
		mips = 1024 * 1;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
		
		//t2.micro
		ram = 1024 * 1;
		mips = 1024 * 1;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
		
		//m1.small
		ram = 1024 * 1.7;
		mips = 1024 * 1;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
		
		//m1.medium
		ram = 1024 * 3.75;
		mips = 1024 * 2;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
		
		//m3.medium
		ram = 1024 * 4;
		mips = 1024 * 4;
		this.vmList.add(new VM(vm_id, ram, mips));
		vm_id++;
	}
	
	public ArrayList<VM> getVmListOneType(int vmNum, int vmIndex) {
		ArrayList<VM> vmSpecList = new ArrayList<VM>();
		double ram = this.vmList.get(vmIndex).getRam();
		double mips = this.vmList.get(vmIndex).getMips();
		
		for(int i=0; i< vmNum; i++) {
			VM vm = new VM(i + 1, ram,  mips);	
			vmSpecList.add(vm);
		}
		return vmSpecList;
	}
	
	public ArrayList<VM> getVmListAllType(){
		return this.vmList;
	}
	public ArrayList<VM> getVmListAllType(int vmNum)
	{
		ArrayList<VM> vmList = new ArrayList<VM>();
		int type;
		Random r = new Random();
		
		for(int i=0; i< vmNum; i++) {
			type = Math.abs(r.nextInt() % this.vmList.size());
			vmList.add(new VM(i + 1, this.vmList.get(type).getRam(), this.vmList.get(type).getMips()));
		}
		return vmList;
	}
	
	public ArrayList<PM> getPmListOneType(int pmNum, int pmIndex) {
		ArrayList<PM> pmSpecList = new ArrayList<PM>();
		
		double ram = this.serverList.get(pmIndex).getRam();
		double mips = this.serverList.get(pmIndex).getMips();
		double pwrIdle = this.serverList.get(pmIndex).getPowerIdle();
		double pwrMax = this.serverList.get(pmIndex).getPowerMax();
		
		for(int i=0; i< pmNum; i++) {
			PM pm = new PM(i + 1, ram, mips);
			pm.setPowerIdle(pwrIdle);
			pm.setPowerMax(pwrMax);
			
			pmSpecList.add(pm);
		}
		return pmSpecList;
	}
	/**
	 * data are taken from specPower benchmark @ https://www.spec.org/power_ssj2008/results/
	 */
	public void setServers() {
		PM pm;
		int pm_id = 0;
		double ram, mips;
		
		//FUJITSU PRIMERGY TX1310 M5, CPU: Intel Xeon E-2356G
		ram = 16 * 1024;
		mips = 6 * 3200;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(15.6);
		pm.setPowerMax(58.9);
		this.serverList.add(pm);
		pm_id++;
		
		//ProLiant DL20 Gen10 Plus, CPU: Intel Xeon E-2388G
		ram = 16 * 1024;
		mips = 8 * 3200;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(21.7);
		pm.setPowerMax(82.8);
		this.serverList.add(pm);
		pm_id++;
		
		//UNIWIDE RC2212, Intel Xeon Silver 4210
		ram = 768 * 1024;
		mips = 20 * 2200;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(127);
		pm.setPowerMax(291);
		this.serverList.add(pm);
		pm_id++;
		
		//LTechKorea LKG-2212-C, CPU: Intel Xeon Gold 6226R
		ram = 512 * 1024;
		mips = 32 * 2900;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(96.6);
		pm.setPowerMax(377);
		this.serverList.add(pm);
		pm_id++;
		
		//Inspur NF5280M5, CPU: Intel Xeon Platinum 8280
		ram = 192 * 1024;
		mips = 56 * 2700;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(48.6);
		pm.setPowerMax(410);
		this.serverList.add(pm);
		pm_id++;
		
		//ProLiant DL325 Gen10 Plus, CPU: AMD EPYC 7773X
		ram = 128 * 1024;
		mips = 64 * 2200;
		pm = new PM(pm_id, ram, mips);
		pm.setPowerIdle(53.2);
		pm.setPowerMax(269);
		this.serverList.add(pm);
		pm_id++;
	}
	
	public ArrayList<PM> getPmListAllType(){
		return this.serverList;
	}
	
	public ArrayList<PM> getPmListAllType(int pmNum){
		ArrayList<PM> pmList = new ArrayList<PM>();
		int type;
		Random r = new Random();
		
		for(int i=0; i< pmNum; i++) {
			type = Math.abs(r.nextInt() % this.serverList.size());
			pmList.add(new PM(i + 1, this.serverList.get(type).getRam(), this.serverList.get(type).getMips()));
		}
		return pmList;
	}
	
}
