package Experiment;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;

import DatacenterSpec.*;

public class ReadFiles {
	private String folderPath;
	private ArrayList<String> fileNames;
	private String tab;
	
	public ReadFiles()
	{
		try
		{
			this.folderPath = System.getProperty("user.dir") + "/ExpSettings/";
			this.fileNames = new ArrayList<String>();			
			this.tab = WriteFiles.tab;
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public ArrayList<PM> getPMspec()
	{
		ArrayList<PM> pmList = new ArrayList<PM>();
	    
		try 
		{
			String fileName = this.folderPath + "pmSpec.txt";
			File file = new File(fileName);
	        Scanner reader = new Scanner(file);
	        
	        reader.nextLine();	//read the header line 
	        while (reader.hasNextLine())
	        {
	        		String line = reader.nextLine();
	        		
	        		if(line.length() == 0)	//empty line
	        			continue;
	        		
		         String[] data = line.split(this.tab);
		         pmList.add(new PM(Integer.parseInt(data[0]), Double.parseDouble(data[1]), Double.parseDouble(data[2])) );
	        }
	        reader.close();
	      } catch (FileNotFoundException e) {
	        System.out.println("An error occurred.");
	        e.printStackTrace();
	      }
		
		return pmList;
	}
	
	public ArrayList<VM> getVMspec()
	{
		ArrayList<VM> vmList = new ArrayList<VM>();
	    
		try 
		{
			String fileName = this.folderPath + "vmSpec.txt";
			File file = new File(fileName);
	        Scanner reader = new Scanner(file);
	        
	        reader.nextLine();	//read the header line 
	        while (reader.hasNextLine())
	        {
	        		String line = reader.nextLine();
	        		
	        		if(line.length() == 0)	//empty line
	        			continue;
	        		
	          String[] data = line.split(this.tab);
		          vmList.add(new VM(Integer.parseInt(data[0]), Double.parseDouble(data[1]), Double.parseDouble(data[2])) );
	        }
	        reader.close();
	      } catch (FileNotFoundException e) {
	        System.out.println("An error occurred.");
	        e.printStackTrace();
	      }
		
		return vmList;
	}

	public ArrayList<ArrayList <Container>> getContspec()
	{
		ArrayList<ArrayList <Container>> contListList = new ArrayList<ArrayList <Container>>();
		
		try 
		{
			String fileName = this.folderPath + "containerSpec.txt";
			File file = new File(fileName);
			Scanner reader = new Scanner(file);
			
			reader.nextLine();	//read the header line 
			while (reader.hasNextLine())
			{
	        		String line = reader.nextLine();
	        		
	        		if(line.length() == 0)	//empty line
	        		{
	        				contListList.add(new ArrayList<Container>());
	        		}
	        			continue;
	        }
			reader.close();
			
			reader = new Scanner(file);
	        
	        reader.nextLine();	//read the header line 
	        for(int i=0; i < contListList.size(); i++)
	        {
	        		ArrayList <Container> contLis = new ArrayList <Container>();
	        		
	        		while (reader.hasNextLine())
	    	        {
	    	        		String line = reader.nextLine();
	    	        		
	    	        		if(line.length() == 0)	//empty line
	    	        			break;
	    	        		
	    	        		String[] data = line.split(this.tab);
	    	        		contLis.add(new Container(Integer.parseInt(data[0]), Double.parseDouble(data[1]), Double.parseDouble(data[2])) );
	    	        }
	        		contListList.set(i, contLis);
	        }
	        
	        reader.close();
	      } 
		catch (FileNotFoundException e) 
		{
	        System.out.println("An error occurred.");
	        e.printStackTrace();
	      }
		
		return contListList;
	}
}
