package Experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.lang.Math;

import CP_Algorithms.*;
import DatacenterSpec.*;
import ExpConfig.*;
import WOA_Config.*;

public class RunExp {
	public static ArrayList<Container> containerSpecList = new ArrayList<Container>();
	public static ArrayList<VM> vmSpecList = new ArrayList<VM>();
	public static ArrayList<PM> pmSpecList = new ArrayList<PM>();
	
	public static String timeUnit = "sec";
	public static WriteFiles fileWriter;
	
	public static void main(String[] args) throws IOException {
		//exp_A();
		//exp_B();
		exp_C();
	}
	
	public static double retTime(long startTime, long endTime)
	{
		return Math.round(((double)endTime - startTime) / 1000);
	}
	
	public static void exp_commenting() {
		/*
		Whale w = new Whale(l);
		w.setRandomSolution(v,p);
		
		//set a solution as a problamatic example 
		//for(int i=0; i < l; i++) 
		{
			w.setVM(0,1);
			w.setVM(1,2);
			w.setVM(2,3);
			
			w.setPM(0,1);
			w.setPM(1,1);
			w.setPM(2,1);
		}
		
		System.out.print("the first solution before repairing it");
		printSingleSolution(w);
		
		w = repairCurrentSolution(w);
		System.out.print("AFTER repair");
		printSingleSolution(w);
		
		
		{
			w.setVM(0,1);
			w.setVM(1,3);
			w.setVM(2,2);
			
			w.setPM(0,2);
			w.setPM(1,2);
			w.setPM(2,2);
		} 

		System.out.print("** print the second solution before repairing it");
		printSingleSolution(w);
		
		w = repairCurrentSolution(w);
		
		System.out.print("AFTER");
		printSingleSolution(w);
		
		System.exit(0);/**/

		/*
		Whale w = new Whale(l);
		w.setRandomSolution(v,p);
		
		System.out.print("** print the solution before repairing it");
		printSingleSolution(w);
		
		w = repairCurrentSolution(w);
		
		System.out.print("AFTER");
		printSingleSolution(w);
		
		System.out.println("================");
		
		//w = new Whale(l);
		w.setRandomSolution(v,p);
		
		System.out.print("** print the solution before repairing it");
		printSingleSolution(w);
		
		repairCurrentSolution(w);
		
		System.out.print("AFTER");
		printSingleSolution(w);
		
		System.exit(0);/**/
	}
	
	/**
	 * simulating experiment 1.A in the DWO_CP paper
	 */
	public static void exp_A() {
		int containerCount = 10;		//number of containers * 100
		int numberRunning = 10;
		ArrayList<Integer> contList =  new ArrayList<Integer>();		//number of container in each list 
		int l = 426;
		int v = 1000;
		int p = 1000;
		int NW = 120;
		int iterN = 100;
		
		System.out.println("starting experiment ... ");
		//System.out.println("startin experiment, l = " + l + ", v = " + v + ", p = " + p + ", NW = " + NW + ", iterN = " + iterN + "\n");
		
		for(int i=1; i <= containerCount; i++)
			contList.add(i * 100);
		
		writeHeaders("ExpA");
		String text = "";
		String tab = fileWriter.getTab();
		
		//numberRunning = contList.size();
		for(int i=0; i< containerCount; i++) 
		{
			l = contList.get(i);
			
			System.out.println("\n\n\t########## Starting container # " + l + " ##########\n\n\n");
			
			//v = p = l;
			for(int j=0; j < numberRunning; j++)
			{
				pmSpecList = new ArrayList<PM>();
				vmSpecList = new ArrayList<VM>();
				Servers dataCenter = new Servers();
				
				setContainerSpecList_8_types(l);
				vmSpecList = dataCenter.getVmListOneType(v, dataCenter.getVmListAllType().size()-1);
				pmSpecList = dataCenter.getPmListOneType(p, 0); //0 is the first pm spec in servers
				
				text = vmSpecList.size() + tab + Double.toString(vmSpecList.get(0).getRam()) + tab + Double.toString(vmSpecList.get(0).getMips());
				fileWriter.writeText(0, text);		//0 for vmSpec
				
				text = pmSpecList.size() + tab + Double.toString(pmSpecList.get(0).getRam()) + tab + Double.toString(pmSpecList.get(0).getMips());
				fileWriter.writeText(1, text);		//1 for pmSpec
				
				text = "";
				for(Container cont: containerSpecList)
				{
					text = text + cont.getId() + tab + cont.getRam() + tab + cont.getMips() + "\n" ;
				}
				fileWriter.writeText(2, text);		//2 for continerSpec
				runCPs(NW, iterN);
				
				System.out.println("-------");
			}
			
			System.out.println("\n\n\t########## Finished container # " + l + " ##########\n\n\n");
		}
	}

	public static void exp_B() {
		int containerCount = 10;		//number of containers * 100
		int numberRunning = 10;
		ArrayList<Integer> contList =  new ArrayList<Integer>();		//number of container in each list 
		int l = 426;
		int v = 1000;
		int p = 1000;
		int NW = 120;
		int iterN = 100;
		
		System.out.println("starting experiment ... ");
		
		for(int i=1; i <= containerCount; i++)
			contList.add(i * 100);
		
		writeHeaders("ExpB");
		String text = "";
		String tab = fileWriter.getTab();
		
		//numberRunning = contList.size();
		for(int i=0; i< containerCount; i++) 
		{
			l = contList.get(i);
			
			System.out.println("\n\n\t########## Starting container # " + l + " ##########\n\n\n");
			
			//v = p = l;
			for(int j=0; j < numberRunning; j++)
			{
				pmSpecList = new ArrayList<PM>();
				vmSpecList = new ArrayList<VM>();
				Servers dataCenter = new Servers();
				
				setContainerSpecList_8_types(l);
				vmSpecList = dataCenter.getVmListAllType(v);
				pmSpecList = dataCenter.getPmListAllType(p); 

				text = "";
				for(VM vm: vmSpecList)
				{
					text = text + vm.getId() + tab + Double.toString(vm.getRam()) + tab + Double.toString(vm.getMips());
				}
				fileWriter.writeText(0, text);		//0 for vmSpec

				text = "";
				for(PM pm: pmSpecList)
				{
					text = text + pm.getId() + tab + Double.toString(pm.getRam()) + tab + Double.toString(pm.getMips());
				}
				fileWriter.writeText(1, text);		//1 for pmSpec
				
				text = "";
				for(Container cont: containerSpecList)
				{
					text = text + cont.getId() + tab + cont.getRam() + tab + cont.getMips() + "\n" ;
				}
				fileWriter.writeText(2, text);		//2 for continerSpec
				runCPs(NW, iterN);
				
				System.out.println("-------");
			}
			
			System.out.println("\n\n\t########## Finished container # " + l + " ##########\n\n\n");
		}		
	}

	/**
	 * tests the number of solution, its impact on the power saving & execution time
	 * runs from number of solutions NW from 10 to 200 (ten options), each solution will be run for 10 times 
	 * # containers = 1000, # pms = 1000, 8 types of containers, different vm and pm types 
	 */
	public static void exp_C() {
		//int containerCount = 1;		//number of containers * 100
		int numberRunning = 10;
		int l = 1000;
		int v = 5000;
		int p = 1000;
		int []NW = {10, 15, 20, 25, 30, 35, 40, 45, 50, 100};
		int iterN = 100;
		
		System.out.println("starting experiment ... ");
		
		writeHeaders("ExpC");
		String text = "";
		String tab = fileWriter.getTab();
		
		//numberRunning = contList.size();
		for(int i=0; i < NW.length; i++) 
		{
			
			System.out.println("\n\n\t########## Starting container # " + l + " ##########\n\n\n");
			
			//v = p = l;
			for(int j=0; j < numberRunning; j++)
			{
				pmSpecList = new ArrayList<PM>();
				vmSpecList = new ArrayList<VM>();
				Servers dataCenter = new Servers();
				
				setContainerSpecList_8_types(l);
				vmSpecList = dataCenter.getVmListAllType(v);
				pmSpecList = dataCenter.getPmListAllType(p); 

				text = "";
				for(VM vm: vmSpecList)
				{
					text = text + vm.getId() + tab + Double.toString(vm.getRam()) + tab + Double.toString(vm.getMips());
				}
				fileWriter.writeText(0, text);		//0 for vmSpec

				text = "";
				for(PM pm: pmSpecList)
				{
					text = text + pm.getId() + tab + Double.toString(pm.getRam()) + tab + Double.toString(pm.getMips());
				}
				fileWriter.writeText(1, text);		//1 for pmSpec
				
				text = "";
				for(Container cont: containerSpecList)
				{
					text = text + cont.getId() + tab + cont.getRam() + tab + cont.getMips() + "\n" ;
				}
				fileWriter.writeText(2, text);		//2 for continerSpec
				
				long startTime, endTime;
				Result result = new Result();
				text = "";
				l = containerSpecList.size();
				v = vmSpecList.size();
				p = pmSpecList.size();
				
				startTime = System.currentTimeMillis();
				
				DCP_old DCP_alg = new DCP_old(l, v, p, NW[i], iterN, containerSpecList, vmSpecList, pmSpecList);
				DCP_alg.startAlgorithm();

				text = l + tab + vmSpecList.size() + tab + pmSpecList.size();;
				endTime = System.currentTimeMillis();

				result = DCP_alg.getOptResult();
				result.setExecTime(retTime(startTime, endTime));
				
				text = text + tab + result.getPower() + tab + result.getVmNum() + tab + result.getPmNum() + tab + result.getExecTime() + tab + result.getSolNum() + tab + result.getSearchSpace();
				fileWriter.writeText(3, text);		//3 for results file
				
				System.out.println("power consumed by the DCP: " + result.getPower() + ", number of unique VMs: " + result.getVmNum() + ", number of unique PMs: " + result.getPmNum() + ", execution time: " + result.getExecTime() + " " + timeUnit + ", solution space: " + result.getSolNum());
				
				System.out.println("-------");
			}
			
			System.out.println("\n\n\t########## Finished NW: " + NW[i] + " ##########\n\n\n");
		}		
	}	
	

	public static void runCPs(int NW, int iterN)
	{
		long startTime, endTime;
		Result result = new Result();
		String tab = fileWriter.getTab();
		String text = "";
		int l = containerSpecList.size();
		int v = vmSpecList.size();
		int p = pmSpecList.size();
		
		startTime = System.currentTimeMillis();
		//NW = ?, IterN = ?
		DCP_old DCP_alg = new DCP_old(l, v, p, 30, 100, containerSpecList, vmSpecList, pmSpecList);
		DCP_alg.startAlgorithm();

		text = l + tab + vmSpecList.size() + tab + pmSpecList.size();;
		endTime = System.currentTimeMillis();

		result = DCP_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));
		
		text = text + tab + result.getPower() + tab + result.getVmNum() + tab + result.getPmNum() + tab + result.getExecTime() + tab + result.getSolNum() + tab + result.getSearchSpace();
		System.out.println("power consumed by the DCP: " + result.getPower() + ", number of unique VMs: " + result.getVmNum() + ", number of unique PMs: " + result.getPmNum() + ", execution time: " + result.getExecTime() + " " + timeUnit);
		///////////////////	
				
		startTime = System.currentTimeMillis();
		
		IGA IGA_alg = new IGA(l, v, p, NW, iterN, containerSpecList, vmSpecList, pmSpecList);
		IGA_alg.startAlgorithm();
		
		endTime = System.currentTimeMillis();

		result = IGA_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));

		text = text + tab + result.getPower() + tab + result.getVmNum() + tab + result.getPmNum() + tab + result.getExecTime() + tab + result.getSolNum() + tab + result.getSearchSpace();
		System.out.println("power consumed by the IGA: " + result.getPower() + ", number of unique VMs: " + result.getVmNum() + ", number of unique PMs: " + result.getPmNum() + ", execution time: " + result.getExecTime() + " " + timeUnit);
		///////////////////

		startTime = System.currentTimeMillis();
		
		R_DWO DWO_alg = new R_DWO(l, v, p, NW, iterN, containerSpecList, vmSpecList, pmSpecList);
		DWO_alg.startAlgorithm();

		endTime = System.currentTimeMillis();

		result = DWO_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));

		text = text + tab + result.getPower() + tab + result.getVmNum() + tab + result.getPmNum() + tab + result.getExecTime() + tab + result.getSolNum() + tab + result.getSearchSpace();
		System.out.println("power consumed by the DWO: " + result.getPower() + ", number of unique VMs: " + result.getVmNum() + ", number of unique PMs: " + result.getPmNum() + ", execution time: " + result.getExecTime() + " " + timeUnit);
		///////////////////
		
		fileWriter.writeText(3, text);		//3 for results file		
	}
	
	public static void test()
	{
		
	}
	
	public static void writeHeaders(String expName)
	{
		fileWriter = new WriteFiles(expName);		 
		String fileName;
		ArrayList<String> headers;
		
		headers = new ArrayList<String>();
		fileName = "vmSpec";
		headers.add("VM#");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = "pmSpec";
		headers.add("PM#");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = "containerSpec";
		headers.add("cont_id");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = expName + "_results";
		headers.add("Container #");
		headers.add("vm #");
		headers.add("pm #");
		
		headers.add("DCP_power");
		headers.add("DCP_vm #");
		headers.add("DCP_pm #");
		headers.add("DCP_time (" + timeUnit + ")");
		headers.add("DCP_solution #");
		headers.add("DCP_search #");
		
		headers.add("IGA_power");
		headers.add("IGA_vm #");
		headers.add("IGA_pm #");
		headers.add("IGA_time (" + timeUnit + ")");
		headers.add("IGA_solution #");
		headers.add("IGA_search#");
		
		headers.add("DWO_power");
		headers.add("DWO_vm #");
		headers.add("DWO_pm #");
		headers.add("DWO_time (" + timeUnit + ")");
		headers.add("DWO_solution #");
		headers.add("DWO_search #");

		fileWriter.writeHeaders(fileName, headers);
	}
	
	private static void printBriefSolution(Whale w) {	
		System.out.println("total power consumed by this solution: " + w.getTotPowerConsumption() + ", number of unique VMs: " + w.getVmTotalUniqueNumber() + ", number of unique PMs: " + w.getPmTotalUniqueNumber());
	}
	
	private static void printSoluionByPm(Whale w) {
		ArrayList<PM> pmList = w.getPmList();
		ArrayList<Integer> pmUniqueIDs = new ArrayList<Integer>(); 
		
		printBriefSolution(w);
		
		for(int i=0; i < pmList.size(); i++) {
			PM pm = pmList.get(i);
			if(pmUniqueIDs.contains(pm.getId()))
				continue;
			pmUniqueIDs.add(pm.getId());
			ArrayList<VM> vmList = pm.getVmList();
			System.out.print("pm #" + pm.getId() + " -- pc = " + pm.getPowerConsumption() + " -- util = " + pm.getUtilization() + " -- contains:");
			for(int j=0; j < vmList.size(); j++) {
				VM vm = vmList.get(j);
				System.out.print(" vm id = " + vm.getId());
			}
			System.out.println();
		}
		System.out.println();
		System.out.println("-------");
		
	}
		
	private static void printSingleSolution(Whale w) {
		int [] vmArray = w.getVmArray();
		int [] pmArray = w.getPmArray();
		
		for(int i=0; i < w.getSolutionSize(); i++) {
			System.out.print( i + " || ");
		}
		System.out.println();
		
		for(int i: vmArray) {
			System.out.print( i + " || ");
		}
		System.out.println();

		for(int i: pmArray) {
			System.out.print( i + " || ");
		}
		System.out.println();
		System.out.println("-------");
		
	}
	
	private static void printSolutionMatrix(ArrayList<Whale> solutionMatrix) {
		int solutionCounter = 0;
		for(Whale w : solutionMatrix) {
			System.out.print("solution " + solutionCounter);
			printSingleSolution(w);
			solutionCounter++;
		}
		
	}
			
	/**
	 * set randomly eight different types of containers
	 * @param containerNum
	 */
	public static void old_setContainerSpecList_8_types(int containerNum) {
		containerSpecList = new ArrayList<Container>();
		ArrayList<Container> contList = new ArrayList<Container>();
		Random r = new Random();
		int type;
		double totMips = 0, totRam = 0;
		
		contList.add(new Container(1, 128, 2329));
		contList.add(new Container(2, 256, 4658));
		contList.add(new Container(3, 512, 9320));
		contList.add(new Container(4, 1024, 18636));
		contList.add(new Container(5, 256, 2329));
		contList.add(new Container(6, 1024, 4658));
		contList.add(new Container(7, 256, 9320));
		contList.add(new Container(8, 128, 18636));
		
		for(int i=0; i< containerNum; i++) {
			type = Math.abs(r.nextInt() % 8);	
			totMips+= contList.get(type).getMips();
			totRam+= contList.get(type).getRam();
			Container c = new Container(i, contList.get(type).getRam(), contList.get(type).getMips());
			containerSpecList.add(c);
		}
		//System.out.println("cont # = " + containerNum + " -- total ram = " + totRam + " -- total mips = " + totMips);
	}

	public static void setContainerSpecList_8_types(int containerNum) {
		containerSpecList = new ArrayList<Container>();
		ArrayList<Container> contList = new ArrayList<Container>();
		Random r = new Random();
		int type;
		double totMips = 0, totRam = 0;
		
		contList.add(new Container(1, 128, 256));
		contList.add(new Container(2, 128, 512));
		contList.add(new Container(3, 128, 1024));
		contList.add(new Container(4, 256, 256));
		contList.add(new Container(5, 256, 512));
		contList.add(new Container(6, 256, 1024));
		contList.add(new Container(7, 512, 512));
		contList.add(new Container(8, 512, 1024));
		
		for(int i=0; i< containerNum; i++) {
			type = Math.abs(r.nextInt() % 8);	
			totMips+= contList.get(type).getMips();
			totRam+= contList.get(type).getRam();
			Container c = new Container(i, contList.get(type).getRam(), contList.get(type).getMips());
			containerSpecList.add(c);
		}
		//System.out.println("cont # = " + containerNum + " -- total ram = " + totRam + " -- total mips = " + totMips);
	}
	
	public static void setContainerSpecList(int containerNum, double ram, double mips) {
		for(int i=0; i< containerNum; i++) {
			Random r = new Random();
			int factor = r.nextInt(4) + 1;	
			
			Container c = new Container(i, ram, mips);
			containerSpecList.add(c);
		}
	}
	
	public static void setVmSpecList(int vmNum, double ram, double mips) {
		vmSpecList = new ArrayList<VM>();
		for(int i=0; i< vmNum; i++) {
			Random r = new Random();
			int factor = r.nextInt(4) + 1 ;	
			
			VM vm = new VM(i + 1, ram,  mips);	
			vmSpecList.add(vm);
		}
	}
	
	public static void setPmSpecList(int pmNum, double ram, double mips) {
		pmSpecList = new ArrayList<PM>();
		for(int i=0; i< pmNum; i++) {
			Random r = new Random();
			int factor = r.nextInt(4) + 1;	
			
			PM pm = new PM(i + 1, ram, mips);	
			
			//Haswell (Xeon 2695) from paper by Khan 2019, title "An energy and performance aware consolidation technique for containerized datacenters"
			pm.setPowerMax(120);
			pm.setPowerIdle(70);
			
			pmSpecList.add(pm);
		}
	}
	
	public static Whale copySolution(Whale solution) {
		Whale w = new Whale(solution.getSolutionSize());

		for(int i=0; i < w.getSolutionSize(); i++) 
		{
			w.addRecord(solution.getVM_id(i), solution.getPM_id(i));
		}
		return w;
	}
}
