package Experiment;

/**
 * to test E_DCP mechanism 
 */

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

import CP_Algorithms.DCP;
import CP_Algorithms.E_DCP;
import CP_Algorithms.IGA;
import CP_Algorithms.R_DWO;
import DatacenterSpec.Container;
import DatacenterSpec.PM;
import DatacenterSpec.PowerPM;
import DatacenterSpec.VM;
import ExpConfig.Result;
import ExpConfig.Servers;
import WOA_Config.PowerWhale;
import WOA_Config.Whale;

public class Test_E_DCP {
	public static ArrayList<Container> containerSpecList = new ArrayList<Container>();
	public static ArrayList<VM> vmSpecList = new ArrayList<VM>();
	public static ArrayList<PM> pmSpecList = new ArrayList<PM>();

	public static int NW = 20;
	public static int iterN = 20;
	public static double OLT = .8; 
	
	public static String timeUnit = "sec";
	public static WriteFiles fileWriter;
	public static ReadFiles fileReaders;
	
	public static String expNameFolder;
	
	public static boolean readInfraFile = true;			//true means read from a file
	
	public static void main(String[] args) throws IOException 
	{
		for (int i=1; i <= 8; i++)
			runExperiment(i);
	}
	
	public static double retTime(long startTime, long endTime)
	{
		//Math.round
		double time = endTime - startTime;
		time = Math.round(time / 10);
		return time/100;
	}
	
	public static void runExperiment(int cp)
	{
		switch(cp)
		{
			case 1:
				expNameFolder = "E_DCP singleSmallContOneTypePM"; 
			break;
			case 2:
				expNameFolder = "E_DCP singleMeduimContOneTypePM"; 
			break;
			case 3:
				expNameFolder = "E_DCP singleLargeContOneTypePM";
			break;
			case 4:
				expNameFolder = "E_DCP MultiContOneTypePM";
			break;
			case 5:
				expNameFolder = "E_DCP singleSmallContMultiPM";				
			break;
			case 6:
				expNameFolder = "E_DCP singleMeduimContMultiPM";			
			break;
			case 7:
				expNameFolder = "E_DCP singleLargeContMultiPM";	
			break;
			case 8:
				expNameFolder = "E_DCP MultiContMultiPM";
			break;
			//we can add data for multiPMSpec i.e. heterogenous infrastrucutre but for limited spec
			default:
				String methodName = "[" + new Object(){}.getClass().getEnclosingClass().getSimpleName() + "." + new Object(){}.getClass().getEnclosingMethod().getName() + "]: ";
				System.out.print( methodName + "error not known algorithm ... exiting the experiment");
				System.exit(0);
		}
		System.out.println("running E_DCP algorithm");
		System.out.println("Experiment type: " + expNameFolder);
		System.out.println("The Experiment started at: " + getDateTime());
		System.out.println("================");
		
		String tableSeperator = "|";
		String tab = "\t";
		
		String headerLine = "alg" + tab + tableSeperator + "cont#" + tab + tableSeperator + "PM#" + tab + tableSeperator + "OLT#" + tab + tableSeperator + "UtlAvg" + tab + tableSeperator + "time" + tab + tableSeperator + "Power (KwH)";
		System.out.println(headerLine);
		
		configure();

		/***********   run the CP algorithms      *************/
		//runCPs(NW, iterN);
	}
	
	/**
	 * tests E_DCP, with regards to power consumption & execution time
	 * solutions NW = 100 run for runNo times 
	 * # containers = 1000, # pms = 1000, 8 types of containers, different vm and pm types 
	 */
	public static void configure() {
		int contMinNum = 500;
		int contMaxNum = 5000;
		
		
		ArrayList<Integer> contList =  new ArrayList<Integer>();		//number of container in each list 
		int l = 426;
		int v = 6000;
		int p = 1000;
		
		//just to run for once 
		for(int i = contMinNum; i <= contMaxNum;)
		{
			contList.add(i);
			i = i + 500;
		}
		
		writeHeaders(expNameFolder);
		String text = "";
		String tab = fileWriter.getTab();

		Servers dataCenter = new Servers();
		pmSpecList = new ArrayList<PM>();
		vmSpecList = new ArrayList<VM>();
		
		readInfraFile = false;	//build new infrastructure data 
		//readInfraFile = true;	//read infrastructure data from files located in "ExpSettings" 
		
		if(readInfraFile)
		{
			fileReaders = new ReadFiles();
			
			pmSpecList = fileReaders.getPMspec();
			vmSpecList = fileReaders.getVMspec();
			
			ArrayList<ArrayList <Container>> contListList = fileReaders.getContspec();

			//System.out.println("contListList.size() = " + contListList.size());
			for(int i = 0; i < contListList.size(); i++)
			{
				containerSpecList = contListList.get(i);
				//System.out.println("containerSpecList.size() = " + containerSpecList.size());
				runCPs(NW, iterN);
			}
		}
		
		else
		{
			vmSpecList = dataCenter.getVmListOneType(v, dataCenter.getVmListAllType().size()-1);
			
			text = "";
			for(VM vm: vmSpecList)
			{
				text = text + vm.getId() + tab + Double.toString(vm.getRam()) + tab + Double.toString(vm.getMips()) + "\n";
			}
			fileWriter.writeText(0, text);		//0 for vmSpec
			

			if(expNameFolder.contains("OneTypePM"))
				pmSpecList = dataCenter.getPmListOneType(p, 0); //0 is the first pm spec in servers
			else
				pmSpecList = dataCenter.getPmListAllType(p); 
			
			text = "";
			for(PM pm: pmSpecList)
			{
				text = text + pm.getId() + tab + Double.toString(pm.getRam()) + tab + Double.toString(pm.getMips()) + "\n";
			}
			fileWriter.writeText(1, text);		//1 for pmSpec

			for(int i = 0; i < contList.size(); i++) 
			{
				l = contList.get(i);
				
				if(expNameFolder.contains("singleSmallCont"))
				{
					double mips[] = {128, 256, 512};
					double ram[] = {128, 256};
					
					setContainerSpecList(l, mips, ram);
				}
				else if(expNameFolder.contains("singleMediumCont"))
				{
					double mips[] = {256, 512, 1024};
					double ram[] = {512, 1024};
					
					setContainerSpecList(l, mips, ram);
				}
				else if(expNameFolder.contains("singleLargeCont"))
				{
					double mips[] = {1024, 2048, 4096};
					double ram[] = {1024, 2048};
					
					setContainerSpecList(l, mips, ram);
				}
				else
				{
					double mips[] = {128, 256, 512, 1024, 2048, 4096};
					double ram[] = {128, 256, 512, 1024, 2048};
					
					setContainerSpecList(l, mips, ram);
				}
				
				text = "";
				for(Container cont: containerSpecList)
				{
					text = text + cont.getId() + tab + cont.getRam() + tab + cont.getMips() + "\n" ;
				}
				fileWriter.writeText(2, text);		//2 for continerSpec
					
				runCPs(NW, iterN);
			}
		}

		System.out.println("================");
		System.out.println("The Experiment finished at: " + getDateTime());
	}	
	public static String printLineFormat(Result result, String tab, String tableSeperator)
	{
		String text = "";
		
		//this for a file
		//text = result.getPower() + tab + "no pm" + tab + result.getPmNum() + tab + result.getExecTime() + tab + result.getSolNum() + tab + result.getSearchSpace() + tab + result.getIdlePmNumber();;
		
		text = result.getAlgName() + tab + tableSeperator + result.getContNum() + tab + tableSeperator + result.getPmNum() + tab + tableSeperator + result.getPMsOLT() + tab + tableSeperator + result.getAvgUtil() + tab + tableSeperator + result.getExecTime() + tab + tableSeperator + result.getPower();
		return text;
	}
	
	public static void runCPs(int NW, int iterN)
	{
		long startTime, endTime;
		Result result = new Result();
		String tab = fileWriter.getTab();
		String text = "";
		int contNum = containerSpecList.size();
		int v = vmSpecList.size();
		int p = pmSpecList.size();
		
		PowerWhale solution =  null;
		
		String tableSeperator = fileWriter.getTableSeperator();
		String outputLine;

		text = contNum + tab + pmSpecList.size();
		
		//*
		////////       begin E_DCP test         ///////////
		startTime = System.currentTimeMillis();
		//NW = ?, IterN = ?
		E_DCP E_DCP_alg = new E_DCP(NW, iterN, containerSpecList, pmSpecList, OLT);

		solution = E_DCP_alg.startAlgorithm();

		
		endTime = System.currentTimeMillis();

		result = E_DCP_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));
		
		text = text + tab + result.getPmNum() + tab + result.getPMsOLT() + tab + result.getAvgUtil() + tab + result.getExecTime() + tab + result.getPower();
		
		tableSeperator = fileWriter.getTableSeperator();
		outputLine = printLineFormat(result, tab, tableSeperator);
		System.out.println(outputLine);

		
		//printPmUtil(solution.getPmList());
				
		////////       finish E_DCP test         ///////////	
		
		//*
		////////       begin DCP test         ///////////	
		startTime = System.currentTimeMillis();
		//NW = ?, IterN = ?
		DCP DCP_alg = new DCP(NW, iterN, containerSpecList, pmSpecList, OLT);
		
		solution = DCP_alg.startAlgorithm();

		endTime = System.currentTimeMillis();

		result = DCP_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));
		
		text = text + tab + result.getPmNum() + tab + result.getPMsOLT() + tab + result.getAvgUtil() + tab + result.getExecTime() + tab + result.getPower();
		
		tableSeperator = fileWriter.getTableSeperator();
		outputLine = printLineFormat(result, tab, tableSeperator);
		System.out.println(outputLine);
		
		//printPmUtil(solution.getPmList());
		
		////////       finish DCP test         ///////////	

		//*
		////////       begin IGA test         ///////////	
		startTime = System.currentTimeMillis();
		
		IGA IGA_alg = new IGA(contNum, v, p, NW, iterN, containerSpecList, vmSpecList, pmSpecList, OLT);
		IGA_alg.startAlgorithm();
		
		endTime = System.currentTimeMillis();

		result = IGA_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));
		
		text = text + tab + result.getPmNum() + tab + result.getPMsOLT() + tab + result.getAvgUtil() + tab + result.getExecTime() + tab + result.getPower();
		
		tableSeperator = fileWriter.getTableSeperator();
		outputLine = printLineFormat(result, tab, tableSeperator);
		System.out.println(outputLine);
		////////       finish IGA test         ///////////	

		/*
		////////       begin R_DWO test         ///////////	
		startTime = System.currentTimeMillis();
		
		R_DWO DWO_alg = new R_DWO(contNum, v, p, NW, iterN, containerSpecList, vmSpecList, pmSpecList, OLT);
		DWO_alg.startAlgorithm();

		endTime = System.currentTimeMillis();

		result = DWO_alg.getOptResult();
		result.setExecTime(retTime(startTime, endTime));
		
		text = text + tab + result.getPmNum() + tab + result.getPMsOLT() + tab + result.getAvgUtil() + tab + result.getExecTime() + tab + result.getPower();
		
		tableSeperator = fileWriter.getTableSeperator();
		outputLine = printLineFormat(result, tab, tableSeperator);
		System.out.println(outputLine);
		////////       finish R_DWO test         ///////////		
		/**/
		
		////print line separator
		outputLine = "================";
		System.out.println(outputLine);
		
		fileWriter.writeText(3, text);		//3 for results file		
	}
	
	
	public static void writeHeaders(String expName)
	{
		fileWriter = new WriteFiles(expName);		 
		String fileName;
		ArrayList<String> headers;
		
		headers = new ArrayList<String>();
		fileName = "vmSpec";
		headers.add("VM#");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = "pmSpec";
		headers.add("PM#");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = "containerSpec";
		headers.add("cont_id");
		headers.add("ram");
		headers.add("cpu");
		fileWriter.writeHeaders(fileName, headers);
		
		headers = new ArrayList<String>();
		fileName = expName + "_results";
		headers.add("Container #");
		headers.add("pm #");
		
		headers.add("E_DCP_pm#");
		headers.add("E_DCP_OLT#");
		headers.add("E_DCP_UtilAvg");
		headers.add("E_DCP_time (" + timeUnit + ")");
		headers.add("E_DCP_power");
		
		headers.add("DCP_pm#");
		headers.add("DCP_OLT#");
		headers.add("DCP_UtilAvg");
		headers.add("DCP_time (" + timeUnit + ")");
		headers.add("DCP_power");
		
		headers.add("IGA_pm#");
		headers.add("IGA_OLT#");
		headers.add("IGA_UtilAvg");
		headers.add("IGA_time (" + timeUnit + ")");
		headers.add("IGA_power");
		
		headers.add("DWO_pm#");
		headers.add("DWO_OLT#");
		headers.add("DWO_UtilAvg");
		headers.add("DWO_time (" + timeUnit + ")");
		headers.add("DWO_power");

		fileWriter.writeHeaders(fileName, headers);
	}
	
	private static void printBriefSolution(Whale w) {	
		System.out.println("total power consumed by this solution: " + w.getTotPowerConsumption() + ", number of unique VMs: " + w.getVmTotalUniqueNumber() + ", number of unique PMs: " + w.getPmTotalUniqueNumber());
	}
	
	private static void printSoluionByPm(Whale w) {
		ArrayList<PM> pmList = w.getPmList();
		ArrayList<Integer> pmUniqueIDs = new ArrayList<Integer>(); 
		
		printBriefSolution(w);
		
		for(int i=0; i < pmList.size(); i++) {
			PM pm = pmList.get(i);
			if(pmUniqueIDs.contains(pm.getId()))
				continue;
			pmUniqueIDs.add(pm.getId());
			ArrayList<VM> vmList = pm.getVmList();
			System.out.print("pm #" + pm.getId() + " -- pc = " + pm.getPowerConsumption() + " -- util = " + pm.getUtilization() + " -- contains:");
			for(int j=0; j < vmList.size(); j++) {
				VM vm = vmList.get(j);
				System.out.print(" vm id = " + vm.getId());
			}
			System.out.println();
		}
		System.out.println();
		System.out.println("-------");
		
	}
		
	private static void printSingleSolution(Whale w) {
		int [] vmArray = w.getVmArray();
		int [] pmArray = w.getPmArray();
		
		for(int i=0; i < w.getSolutionSize(); i++) {
			System.out.print( i + " || ");
		}
		System.out.println();
		
		for(int i: vmArray) {
			System.out.print( i + " || ");
		}
		System.out.println();

		for(int i: pmArray) {
			System.out.print( i + " || ");
		}
		System.out.println();
		System.out.println("-------");
		
	}
	
	private static void printSolutionMatrix(ArrayList<Whale> solutionMatrix) {
		int solutionCounter = 0;
		for(Whale w : solutionMatrix) {
			System.out.print("solution " + solutionCounter);
			printSingleSolution(w);
			solutionCounter++;
		}
		
	}
			
	/**
	 * set randomly eight different types of containers
	 * @param containerNum
	 */
	public static void setContainerSpecList(int containerNum) {
		containerSpecList = new ArrayList<Container>();
		ArrayList<Container> contList = new ArrayList<Container>();
		Random r = new Random();
		int type;

		contList.add(new Container(1, 128, 256));
		contList.add(new Container(2, 128, 512));
		contList.add(new Container(3, 256, 512));
		contList.add(new Container(4, 256, 1024));
		contList.add(new Container(5, 512, 1024));
		contList.add(new Container(6, 512, 2048));

		for(int i=0; i< containerNum; i++) {
			type = Math.abs(r.nextInt() % contList.size());
			Container c = new Container(i, contList.get(type).getRam(), contList.get(type).getMips());
			containerSpecList.add(c);
		}
	}
	
	public static void setContainerSpecList(int containerNum, double ram, double mips) {
		containerSpecList = new ArrayList<Container>();
		for(int i=0; i< containerNum; i++) {
			Container c = new Container(i, ram, mips);
			containerSpecList.add(c);
		}
	}
	
	public static void setContainerSpecList(int containerNum, double[] ram, double[] mips) {
		containerSpecList = new ArrayList<Container>();
		for(int i=0; i< containerNum; i++) {
			Container c = new Container(i, ram[getRandNum(0, ram.length)], mips[getRandNum(0, mips.length)]);
			containerSpecList.add(c);
		}
	}
	
	public static int getRandNum(int lowerBound, int upperBound)
	{
		int num = 0;
		Random r = new Random();
		num = r.nextInt(upperBound) + lowerBound;	
		
		return num;
	}
	
	public static void setVmSpecList(int vmNum, double ram, double mips) {
		vmSpecList = new ArrayList<VM>();
		for(int i=0; i< vmNum; i++) {
			Random r = new Random();
			int factor = r.nextInt(4) + 1 ;	
			
			VM vm = new VM(i + 1, ram,  mips);	
			vmSpecList.add(vm);
		}
	}
	
	public static void setPmSpecList(int pmNum, double ram, double mips) {
		pmSpecList = new ArrayList<PM>();
		for(int i=0; i< pmNum; i++) {
			Random r = new Random();
			int factor = r.nextInt(4) + 1;	
			
			PM pm = new PM(i + 1, ram, mips);	
			
			//Haswell (Xeon 2695) from paper by Khan 2019, title "An energy and performance aware consolidation technique for containerized datacenters"
			pm.setPowerMax(120);
			pm.setPowerIdle(70);
			
			pmSpecList.add(pm);
		}
	}
	
	public static Whale copySolution(Whale solution) {
		Whale w = new Whale(solution.getSolutionSize());

		for(int i=0; i < w.getSolutionSize(); i++) 
		{
			w.addRecord(solution.getVM_id(i), solution.getPM_id(i));
		}
		return w;
	}
	//*
	public static void printPmUtil(ArrayList<PowerPM> pmList)
	{		
		for(int i=0; i < pmList.size(); i++)
		{
			//if(pmList.get(i).getContainerList().size() > 0)
				printPmMsg(pmList.get(i));
		}
	}/**/
	
	public static void printPmMsg(PowerPM pm, int i)
	{
		System.out.println("#: " + i + " -- pm id: " + pm.getId() + " -- pm.util = " + Math.round(100 * pm.getUtilization()));
	}
	
	public static void printPmMsg(PowerPM pm)
	{
		System.out.println("pm id: " + pm.getId() + " -- pm.util = " + Math.round(100 * pm.getUtilization()) + " -- # cont = " + pm.getContainerList().size());
	}
	
	public static String getDateTime()
	{
	    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");  
	    Date date = new Date(); 
		return formatter.format(date);
	}
}
