package Experiment;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class WriteFiles {
	private String folderPath;
	private ArrayList<String> fileNames;
	private String tableSeperator = "|";

	public static String tab = "\t";
	
	/**
	 * opens a folder, if it does not exit, creates a new one
	 * @param folderName the name of the folder e.g. expA which contains the result of the experiment and the spec of cloudletlets, VMs and PMs as separate files
	 */
	public WriteFiles(String folderName)
	{
		try
		{
			this.folderPath = System.getProperty("user.dir") + "/output/";
			this.fileNames = new ArrayList<String>();
			
			File folder = new File(this.folderPath);
			if (!folder.exists()) {
				folder.mkdir();
			}
			
			this.folderPath = this.folderPath + folderName + "/";
			folder = new File(this.folderPath);
			if (!folder.exists()) {
				folder.mkdir();
			}

			//delete all files in folderName
			for(File file: folder.listFiles()) 
			    if (!file.isDirectory()) 
			        file.delete();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public void writeHeaders(String fileName, ArrayList<String> headers)
	{
		BufferedWriter writer = null;
		
		try
		{
			boolean append = false;
			String txt = "";

			for(String header: headers)
			{
				txt = txt + header + tab;
			}

			fileName = this.folderPath + fileName + ".txt";
			
			File file = new File(fileName);
			file.createNewFile();
			
			fileNames.add(fileName);
			
		    writer = new BufferedWriter( new FileWriter(fileName, append));
		    writer.write(txt);		
		    writer.newLine();
		}
		catch ( IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
		    try
		    {
		        if ( writer != null)
		        	writer.close( );
		    }
		    catch ( IOException e)
		    {
				e.printStackTrace();
		    }
		}
	}
	
	/**
	 * 
	 * @param fileIndex: 0 for vmSpec, 1 for pmSpec, 2 for continaerSpec and 3 for exp results
	 */
	public void writeText(int fileIndex, String txt)
	{
		BufferedWriter writer = null;
		
		try
		{
			String fileName = this.fileNames.get(fileIndex);
			
			boolean append = true;
		    writer = new BufferedWriter( new FileWriter(fileName, append));
		    writer.write(txt);		
		    writer.newLine();
		}
		catch ( IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
		    try
		    {
		        if ( writer != null)
		        	writer.close( );
		    }
		    catch ( IOException e)
		    {
				e.printStackTrace();
		    }
		}
	}
	
	public void setTab(String tab)
	{
		this.tab = tab;
	}
	public String getTab()
	{
		return this.tab;
	}
	public String getTableSeperator()
	{
		return this.tableSeperator;
	}
}
