package WOA_Config;

import java.util.ArrayList;
import java.util.Random;
import DatacenterSpec.*;

public class PowerWhale {

	private ArrayList <PowerPM>   pmList;		//list of PMs, each PM contains a list of conatiners
	
	public PowerWhale()
	{
		this.pmList = new ArrayList<PowerPM>();
	}
	
	public void addPM(PowerPM pm)
	{
		pmList.add(pm);
	}
	
	public void setPmList(ArrayList<PowerPM> pmList)
	{
		this.pmList = pmList;		//may need to run a copy
	}
	
	public ArrayList<PowerPM> getPmList()
	{
		return this.pmList;
	}
	
	public PowerPM getPMbyIndex(int index)
	{
		return pmList.get(index);
	}
	
	public void setPMbyIndex(int index, PowerPM pm)
	{
		pmList.set(index, pm);
	}
	
	public int getPMindexbyContainer(Container cont)
	{
		for(int pmIndex = 0; pmIndex< pmList.size(); pmIndex++)
		{
			for(Container tmpCont: pmList.get(pmIndex).getContainerList())
			{
				if(cont.getId() == tmpCont.getId())
					return pmIndex;
			}
		}
		return -1;
	}
	
	
	public PowerPM getPMbyContainer(Container cont)
	{
		for(int pmIndex = 0; pmIndex< pmList.size(); pmIndex++)
		{
			for(Container tmpCont: pmList.get(pmIndex).getContainerList())
			{
				if(cont.getId() == tmpCont.getId())
					return pmList.get(pmIndex);
			}
		}
		return null;
	}
	
	public int getPMbyContainerID(int contId)
	{
		for(int pmIndex =0; pmIndex < pmList.size(); pmIndex++)
		{
			for(Container cont:pmList.get(pmIndex).getContainerList())
			{
				if(contId == cont.getId())
					return pmIndex;
			}
		}
		return -1;
	}
	
	/**
	 * 
	 * @return all containers in all pms in a solution
	 */
	public ArrayList<Container> getAllContainerList()
	{
		
		ArrayList<Container> contList = new ArrayList<Container>();
		
		for(PowerPM pm: this.getPmList())
		{
			contList.addAll(pm.getContainerList());
		}
		
		return contList;
	}
	
	public boolean migrateContainer(int curPM_id, int tarPM_id, Container cont)
	{
		boolean ret = false;
		
		if(this.getPMbyIndex(tarPM_id).canHost(cont))
		{
			PowerPM pm = null;
			
			pm = this.getPMbyIndex(curPM_id);
			ArrayList<Container> contList = pm.getContainerList();
			
			if(!contList.remove(cont))
			{
				return ret;
			}
			
			pm.setContainerList(contList);		
			this.setPMbyIndex(curPM_id, pm);
			
			pm = this.getPMbyIndex(tarPM_id);
			pm.addContainer(cont);
			this.setPMbyIndex(tarPM_id, pm);
			
			ret = true;
		}
		
		return ret;
	}

	public double getTotPowerConsumption()
	{
		double totalPower =0;
		
		for(PowerPM pm: pmList)
		{
			if(pm.getUtilization() ==0)
				continue;
			
			totalPower += pm.getPowerConsumption();
		}
		
		return Math.round(totalPower);
	}
	public int getIdlePmNumber()
	{
		int idlePmNumber = 0;
		for(PowerPM pm: pmList)
		{
			if (pm.getUtilization() == 0)
				idlePmNumber++;
		}
		return idlePmNumber;
	}
	
	public double getTotUtil()
	{
		double totUtil = 0;

		for(PowerPM pm: pmList)
		{
			totUtil += pm.getUtilization();
		}
		
		return totUtil;
	}
	
	public int getActivePmNo()
	{
		int pmNo = 0;
		for(PowerPM pm: pmList)
		{
			if(pm.getTotAllocatedMips() > 0)
				pmNo++;
		}
		return pmNo;
	}
	
	public double getAvgUtilLevel()
	{
		return Math.round(100 * this.getTotUtil()/this.getActivePmNo());
	}
	
	public int getTotOverLoadedPMs(double OLT)
	{
		int numberOL = 0;


		for(PowerPM pm: pmList)
		{
			if(pm.getUtilization() > OLT)
				numberOL++;
		}
		return numberOL;
	}
}
