package WOA_Config;

import java.util.ArrayList;
import java.util.Random;
import DatacenterSpec.*;

/**
 * represents a sultion which contains l containers stored in an arraylist, each container is assigned to vm_id and pm_id
 * vm_id and pm_id numbering starting from 1
 * @author abdulelah
 *
 */
public class Whale {
	private ArrayList <containerInfo>recordList;	//matrix 2*l, the first row represents a vm_id and the second represents a pm_id
	private int l;		//denotes the number of containers
	/**
	 * initilizes the Whale
	 * @param l		the number of containers
	 */
	public Whale(int l)
	{
		this.l = l;
		this.recordList = new ArrayList <containerInfo>();
	}

	/**
	 * sets initial values for the current solutions with upper bounds 
	 * @param v
	 * @param p
	 */
	public void setRandomSolution(int v, int p)
	{
		Random random = new Random();
		for(int i=0; i < this.l; i++) {
			recordList.add(new containerInfo(random.nextInt(v) + 1, random.nextInt(p) + 1));
		}
	}

	public void setContainerListForVmList(ArrayList<VM> vmList)
	{
		for(VM vm: vmList) {
			ArrayList<Container> contList = new ArrayList<Container>(vm.getContainerList());
			for(Container cont: contList) {
				this.recordList.get(cont.getId()).setVM(vm);
			}
		}
	}
	
	public void setVmListForPmList(ArrayList<PM> pmList) {
		for(PM pm: pmList) {
			ArrayList<VM> vmList = new ArrayList<VM>(pm.getVmList());
			for(VM vm: vmList) {
				for(int i=0; i < this.recordList.size(); i++) {
					if(vm.getId() == this.recordList.get(i).getVM_id()) {
						this.recordList.get(i).setPM(pm);
					}
				}
			}
		}
	}
	
	/**
	 * sets initial values for the current solutions with l as upper bound
	 */
	public void setRandomSolution()
	{
		Random random = new Random();
		int numberContainers = this.l;;
		for(int i=0; i < numberContainers; i++) {
			recordList.add(new containerInfo(random.nextInt(numberContainers) + 1, random.nextInt(numberContainers) + 1));
		}
	}

	public int getVM_id(int l_index)
	{
		return this.recordList.get(l_index).getVM_id();
	}
	public VM getVM(int l_index)
	{
		return this.recordList.get(l_index).getVM();
	}
	
	public void addRecord(int vm, int pm) {
		recordList.add(new containerInfo(vm, pm));	
	}
	/**
	 * returns the arraylist of vm_id and pm_id for each container
	 * @return
	 */
	public ArrayList<containerInfo> getRecordList()
	{
		return this.recordList;
	}
	/**
	 * set the record list which containers vm_id and pm_id for all containers 
	 * @param recordList
	 */
	public void setRecordList(ArrayList<containerInfo> recordList)
	{
		this.recordList = new ArrayList<containerInfo>(recordList);
	}
	
	public void setVM_id(int l_index, int vm_id)
	{
		if(vm_id == 0)
			vm_id = 1;
		vm_id = Math.abs(vm_id);
		
		containerInfo container = new containerInfo();
		container.setVM_id(vm_id);
		container.setPM_id(this.recordList.get(l_index).getPM_id());
		
		this.recordList.set(l_index, container);
	}

	public void setVM(int l_index, VM vm) {
		containerInfo container = new containerInfo();
		container.setVM_id(vm.getId());
		container.setVM(vm);
		
		container.setPM_id(this.recordList.get(l_index).getPM_id());
		container.setPM(this.recordList.get(l_index).getPM());
		
		this.recordList.set(l_index, container);
	}
	
	public int getPM_id(int l_index)
	{
		return recordList.get(l_index).getPM_id();
	}

	public void setPM_id(int l_index, int pm_id)
	{
		if(pm_id == 0)
			pm_id = 1;
		pm_id = Math.abs(pm_id);
		
		containerInfo container = new containerInfo();
		container.setVM_id(this.recordList.get(l_index).getVM_id());
		container.setPM_id(pm_id);
		
		this.recordList.set(l_index, container);
	}

	public void setPM(int l_index, PM pm)
	{
		containerInfo container = new containerInfo();

		container.setVM_id(this.recordList.get(l_index).getVM_id());
		container.setVM(this.recordList.get(l_index).getVM());
		
		container.setPM_id(pm.getId());
		container.setPM(pm);
		
		this.recordList.set(l_index, container);
	}
	
	/**
	 * returns the size of each row i.e. the number of containers
	 * @return size 
	 */
	public int getSolutionSize()
	{
		return this.l;	
	}
	
	public int[] getVmArray()
	{
		int []vmArray = new int[this.l];
		for(int i=0; i < this.l; i++) {
			vmArray[i] = this.recordList.get(i).getVM_id();
		}
		return vmArray; 
	}
	
	public int[] getPmArray()
	{
		int []vmArray = new int[this.l];
		for(int i=0; i < this.l; i++) {
			vmArray[i] = this.recordList.get(i).getPM().getId();
		}
		return vmArray;
	}
	
	public ArrayList<PM> getPmList(){
		ArrayList<PM> pmList = new ArrayList<PM>();
		for(int i=0; i < this.getSolutionSize(); i++) {
			pmList.add(this.recordList.get(i).getPM());
		}
		return pmList;
	}
	
	public void setPmList(ArrayList<PM> pmList){
		this.setVmListForPmList(pmList);
	}
	
	public ArrayList<Integer> getUniqueVmIdList() {
		int[] vmArray = this.getVmArray();
		ArrayList<Integer> uniqueVmIdList = new ArrayList<Integer>();	// list contains vm_ids uniquely 
		
		for(int i = 0; i < vmArray.length; i++)
		{
			if(!uniqueVmIdList.contains(vmArray[i]))
				uniqueVmIdList.add(vmArray[i]);
		}
		return uniqueVmIdList;
	}
	
	public int getVmTotalUniqueNumber()
	{
		return this.getUniqueVmIdList().size();
	}
	
	public ArrayList<Integer> getUniquePmIdList() {
		int[] pmArray = this.getPmArray();
		ArrayList<Integer> uniquePmIdList = new ArrayList<Integer>();	// list contains vm_ids uniquely 
		
		for(int i = 0; i < pmArray.length; i++)
		{
			if(!uniquePmIdList.contains(pmArray[i]))
				uniquePmIdList.add(pmArray[i]);
		}
		return uniquePmIdList;
	}
	
	public int getPmTotalUniqueNumber()
	{
		return this.getUniquePmIdList().size();
	}
	public double getTotPowerConsumption()
	{
		double p =0;
		ArrayList<Integer> pmUniqueIDs = new ArrayList<Integer>(); 
		
		for(int i=0; i < this.getSolutionSize(); i++) {
			PM pm = this.recordList.get(i).getPM();
			
			if(!pmUniqueIDs.contains(pm.getId())){
				pmUniqueIDs.add(pm.getId());
				p+= pm.getPowerConsumption();
			}
		}
		return Math.round(p);
	}
	
	public double getAvgUtilLevel()
	{
		ArrayList<Integer> pmUniqueIDs = new ArrayList<Integer>(); 
		double totUtil = 0;
		
		for(int i=0; i < this.getSolutionSize(); i++) {
			PM pm = this.recordList.get(i).getPM();
			
			if(!pmUniqueIDs.contains(pm.getId())){
				pmUniqueIDs.add(pm.getId());
				totUtil  += pm.getUtilization();
			}
		}
		
		return Math.round(100 * totUtil/pmUniqueIDs.size());
	}
	
	public int getTotOverLoadedPMs(double OLT)
	{
		int numberOL = 0;
		ArrayList<Integer> pmUniqueIDs = new ArrayList<Integer>(); 
		
		for(int i=0; i < this.getSolutionSize(); i++) {
			PM pm = this.recordList.get(i).getPM();
			
			if(!pmUniqueIDs.contains(pm.getId())){
				pmUniqueIDs.add(pm.getId());
				if(pm.getUtilization() >= OLT)
					numberOL++;
			}
		}
		return numberOL;
	}
}
