package WOA_Config;

import java.util.ArrayList;
import DatacenterSpec.*;

/**
 * a class represents the details of each container, its hosted vm and its hoasted host
 * @author abdulelah
 *
 */
public class containerInfo {
	private VM vm;
	private PM pm;

	public containerInfo(int vm_id, int pm_id) {
		this.vm = new VM();
		this.pm = new PM();
		
		this.vm.setId(vm_id);
		this.pm.setId(pm_id);
		
	}

	public containerInfo() {
		this.vm = new VM();
		this.pm = new PM();
	}
	public void setVM(VM vm)
	{
		this.vm = new VM(vm.getId(), vm.getRam(), vm.getMips());
		this.vm.setContainerList(new ArrayList<Container>(vm.getContainerList()));
	}
	public void setVM_id(int vm_id)
	{
		this.vm.setId(vm_id);
	}
	public VM getVM()
	{
		return this.vm;
	}
	
	public int getVM_id() 
	{
		return vm.getId();
	}
	
	public void setPM(PM pm)
	{
		this.pm = new PM(pm.getId(), pm.getRam(), pm.getMips());
		this.pm.setVmList(new ArrayList<VM>(pm.getVmList()));
		this.pm.setPowerMax(pm.getPowerMax());
	}
	
	public void setPM_id(int pm_id)
	{
		this.pm.setId(pm_id);
	}
	
	public PM getPM()
	{
		return this.pm;
	}
	
	public int getPM_id()
	{
		return pm.getId();
	}
}
