# python implementation of Grey wolf optimization (GWO)
# minimizing rastrigin and sphere function

from optimization.other.algorithm import Algorithm
import random
import math    # cos() for Rastrigin
import copy    # array-copying convenience
import sys     # max float


#-------fitness functions---------

# rastrigin function
def fitness_rastrigin(position):
    fitness_value = 0.0
    for i in range(len(position)):
        xi = position[i]
        fitness_value += (xi * xi) - (10 * math.cos(2 * math.pi * xi)) + 10
    return fitness_value

#sphere function
def fitness_sphere(position):
    fitness_value = 0.0
    for i in range(len(position)):
        xi = position[i]
        fitness_value += (xi*xi);
    return fitness_value;
#-------------------------


# wolf class
class wolf:
    def __init__(self, fitness, dim, minx, maxx, seed):
        self.rnd = random.Random(seed)
        self.position = [0.0 for i in range(dim)]

        for i in range(dim):
            self.position[i] = ((maxx - minx) * self.rnd.random() + minx)

        self.fitness = fitness(self.position) # curr fitness


# grey wolf optimization (GWO)
def gwo(fitness, max_iter, n, dim, minx, maxx, is_maximizing):
    rnd = random.Random(0)

    # create n random wolves
    population = [ wolf(fitness, dim, minx, maxx, i) for i in range(n)]

    # On the basis of fitness values of wolves
    # sort the population in asc order
    population = sorted(population, key = lambda temp: temp.fitness)

    # best 3 solutions will be called as
    # alpha, beta and gaama
    alpha_wolf, beta_wolf, gamma_wolf = copy.copy(population[: 3])


    # main loop of gwo
    Iter = 0
    while Iter < max_iter:
        print('Iter: ' + str(Iter))
        # after every 10 iterations
        # print iteration number and best fitness value so far
        if Iter % 10 == 0 and Iter > 1:
            print("Iter = " + str(Iter) + " best fitness = %.3f" % alpha_wolf.fitness)

            # linearly decreased from 2 to 0
        a = 2*(1 - Iter/max_iter)

        # updating each population member with the help of best three members
        for i in range(n):
            A1, A2, A3 = a * (2 * rnd.random() - 1), a * (
                    2 * rnd.random() - 1), a * (2 * rnd.random() - 1)
            C1, C2, C3 = 2 * rnd.random(), 2*rnd.random(), 2*rnd.random()

            X1 = [0.0 for i in range(dim)]
            X2 = [0.0 for i in range(dim)]
            X3 = [0.0 for i in range(dim)]
            Xnew = [0.0 for i in range(dim)]
            for j in range(dim):
                X1[j] = alpha_wolf.position[j] - A1 * abs(
                    C1 * alpha_wolf.position[j] - population[i].position[j])
                X2[j] = beta_wolf.position[j] - A2 * abs(
                    C2 *  beta_wolf.position[j] - population[i].position[j])
                X3[j] = gamma_wolf.position[j] - A3 * abs(
                    C3 * gamma_wolf.position[j] - population[i].position[j])
                Xnew[j]+= X1[j] + X2[j] + X3[j]

            for j in range(dim):
                Xnew[j]/=3.0

            # fitness calculation of new solution
            fnew = fitness(Xnew)

            # greedy selection
            if (not is_maximizing and fnew < population[i].fitness) or (is_maximizing and fnew > population[i].fitness):
                population[i].position = Xnew
                population[i].fitness = fnew

                # On the basis of fitness values of wolves
        # sort the population in asc order
        population = sorted(population, key = lambda temp: temp.fitness)

        # best 3 solutions will be called as
        # alpha, beta and gaama
        alpha_wolf, beta_wolf, gamma_wolf = copy.copy(population[: 3])

        Iter+= 1
    # end-while

    # returning the best solution
    return alpha_wolf.position

print("\nBest grey wolf optimization on TSP and VRP\n")
selected_poi = ['12','11','15','17','22','25','28','42','39','36','32','31','46','45','50','51','59','63','89','85','93']


class GWO_VRP(Algorithm):
    def run_GWO(self):
        dim = len(selected_poi)
        fitness = self.fitness_function
        num_particles = 10
        max_iter = 10
        best_position = gwo(fitness, max_iter, num_particles, dim, 0, 10, True)
        return best_position

    def construct_solution(self):
        x_best = self.run_GWO()
        output = self.get_output([x_best])


class GWO_TSP(GWO_VRP):
    def run_GWO(self):
        dim = len(selected_poi)
        fitness = self.tsp_fitness_function
        num_particles = 10
        max_iter = 10
        best_position = gwo(fitness, max_iter, num_particles, dim, 0, 10, False)
        return best_position
