# Blending
import pandas as pd
from sklearn.linear_model import LinearRegression
from sklearn.tree import DecisionTreeRegressor
from sklearn.ensemble import RandomForestRegressor
from sklearn.model_selection import train_test_split
from sklearn.metrics import mean_squared_error, r2_score, mean_absolute_error
import matplotlib.pyplot as plt
import numpy as np

file_path = r""
data = pd.read_excel(file_path, header=None) 

X = data.iloc[:, 1:]  
y = data.iloc[:, 0]  

X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

base_models = [
    LinearRegression(),
    DecisionTreeRegressor(random_state=42),
    RandomForestRegressor(random_state=42)
]

meta_features_train = np.zeros((X_train.shape[0], len(base_models)))
meta_features_test = np.zeros((X_test.shape[0], len(base_models)))

for i, model in enumerate(base_models):
    model.fit(X_train, y_train)
    meta_features_train[:, i] = model.predict(X_train)
    meta_features_test[:, i] = model.predict(X_test)

meta_model = LinearRegression()
meta_model.fit(meta_features_train, y_train)

meta_predictions = meta_model.predict(meta_features_test)

rmse = np.sqrt(mean_squared_error(y_test, meta_predictions))
print(f'（RMSE）: {rmse}')

r2 = r2_score(y_test, meta_predictions)
print(f'R2 : {r2}')

mae = mean_absolute_error(y_test, meta_predictions)
print(f'（MAE）: {mae}')

plt.scatter(y_test, meta_predictions)
plt.plot([min(y_test), max(y_test)], [min(y_test), max(y_test)], '--k')
plt.xlabel('True Values')
plt.ylabel('Predictions')
plt.title(' True Values vs Predictions ')
plt.show()

