%  GAN model for Securing Biometric authentication system version 1.0                                       %
% Main paper: "A keyless multimodal-based user authentication scheme using a generative adversarial network"  %
%                                                                                                          
Mayada Tarek Corresp , Eslam Hamouda  , Amjad Alsirhani  , Abdullah Alomari  , Ayman Mohamed Mostafa                                                                     %
%                                                                                                           %
%   Based on code devloped by @JZhaoCH, https://github.com/JZhaoCH/Simple-GAN-Base-on-Matlab                %
% And, Libor Masek, Peter Kovesi. MATLAB Source Code for iris Biometric Identification                      %
% System Based on Iris Patterns. The School of Computer Science and Software Engineering,                   % 
% The University of Western Australia. 2003.                                                                %


function [FAR, FRR,EER,d]=EER_value_Draw_ED(hd_intra,hd_inter)

[m n]=size(hd_intra);
[mm nn]=size(hd_inter);


pas0=1000;

m0 = max (hd_intra);

% size of client vector
num_clients = length (hd_intra);

% minimum impostor scores
m1 = min (hd_inter);

% size of impostor vector
num_imposteurs = length (hd_inter);

% calculation of the step
pas1 = (m0 - m1)/pas0;
x = [m1:pas1:m0]';
num = length (x);
        c=1;
        for interval=1:num
           cutpoint=interval;
            count=0;
           for i=1:n
              if hd_intra(i)>= x(cutpoint)
                  count=count+1;
              end
           end
            %FRR(c)=count/n;
            FRR(c)=100*count/n;
            count=0;
            for i=1:nn
              if hd_inter(i)< x(cutpoint)
                  count=count+1;
              end
            end
            % FAR(c)=count/nn;
           FAR(c)=100*count/nn;
           c=c+1;
          
        end
      
        tmp1=find (FRR-FAR<=0);
        tmps=length(tmp1);

        if ((FAR(tmps)-FRR(tmps))<=(FRR(tmps+1)-FAR(tmps+1)))
               EER_new=(FAR(tmps)+FRR(tmps))/2;tmpEER=tmps;
        else
              EER_new=(FRR(tmps+1)+FAR(tmps+1))/2;tmpEER=tmps+1;
        end
        
        
       [XXX,YYY]=curveintersect(x,FAR,x,FRR);
        
       minn=abs(FAR(1)-FRR(1));
        FF=1;
        
        for QQ=2:length(FAR)
            if(abs(FAR(QQ)-FRR(QQ))< minn)
                minn=abs(FAR(QQ)-FRR(QQ));
                FF=QQ;
            end
        end
               
        EER_eslam=(FAR(FF)+FRR(FF))/2
       
       
        figure;
        plot(FRR,100-FAR,'b');
        xlabel('FRR');
        ylabel('FAR');
        title (strcat('ROC curve graph '));
       
        
       figure, plot(x,FRR,'r',x,FAR,'b');
       legend('FRR','FAR');
        xlabel('Hamming Distance Threeshold values');
        ylabel('Error');
        title (strcat('FAR vs FRR graph '));
        
        
       
        EER=YYY;

       d=(abs(mean(hd_intra)-mean(hd_inter)))/(sqrt(var(hd_intra)+var(hd_inter))); 
           
     
end