  

function [Cancellable_template,generator]=GAN_Model(Permuted_sample,Training_samples,Training_samples_mean,Generator_hidden_neuron,Discriminator_hidden_neuron,epoch,learning_rate)


generator = nnsetup([size(Training_samples,2),Generator_hidden_neuron, size(Permuted_sample,2)]);
discriminator = nnsetup([size(Permuted_sample,2),Discriminator_hidden_neuron, 1]);

% -----------  Start training
batch_size = 1;
images_num = size(Training_samples,1);   
batch_num = ceil(images_num / batch_size);

for e=1:epoch
    for t=1:batch_num
        % Prepare data
        images_real = Permuted_sample;
        noise = Training_samples(t,:);
 
        % Start training
        % -----------  Update generator, fixed discriminator
        
        generator = nnff(generator, noise);
        Generator_output = generator.layers{generator.layers_count}.a;
        discriminator = nnff(discriminator, Generator_output);
        logits_fake = discriminator.layers{discriminator.layers_count}.z;
        discriminator = nnbp_d(discriminator, logits_fake, ones(batch_size, 1));
        generator = nnbp_g(generator, discriminator);
        generator = nnapplygrade(generator, learning_rate);
        % -----------  Update discriminator, fixed generator
        
        generator = nnff(generator, noise);
        Generator_output = generator.layers{generator.layers_count}.a;
        images = [Generator_output;images_real];
        discriminator = nnff(discriminator, images);
        logits = discriminator.layers{discriminator.layers_count}.z;
        labels = [zeros(batch_size,1);ones(batch_size,1)];
        discriminator = nnbp_d(discriminator, logits, labels);
        discriminator = nnapplygrade(discriminator, learning_rate);
        % ---------------- Output loss
        if t == batch_num
            c_loss = sigmoid_cross_entropy(logits(1:batch_size), ones(batch_size, 1));
            d_loss = sigmoid_cross_entropy(logits, labels);
        end
    end
end   
  % -----------  End training the simple_GAN_on matlab -----------%

  %----------- Binarize the Genrator's output and the mean of the Traning_samples ----------------%
 
  for jjjj=1:size(Generator_output,2)
     if Generator_output(jjjj)>=0.5
           Generator_output(jjjj)=1;
           else
           Generator_output(jjjj)=0;
     end
  end
  
   for jjjj=1:size(Training_samples_mean,2)
     if Training_samples_mean(jjjj)>=0.5
           Training_samples_mean(jjjj)=1;
           else
           Training_samples_mean(jjjj)=0;
     end
   end
   %---------------------Create the Stored Cancellable Template-------------------%
        
        Cancellable_template=xor(Generator_output,Training_samples_mean);
         
end