function  Multi_biometric_Bio_GAN_Feature_Fusion()


%%  GAN model for Securing Biometric authentication system version 1.0                                       %
% Main paper: "A keyless multimodal-based user authentication scheme using a generative adversarial network"  %
%                                                                                                          
Mayada Tarek Corresp , Eslam Hamouda  , Amjad Alsirhani  , Abdullah Alomari  , Ayman Mohamed Mostafa    
%                                                                                                           %
%   Based on code devloped by @JZhaoCH, https://github.com/JZhaoCH/Simple-GAN-Base-on-Matlab                %
% And, Libor Masek, Peter Kovesi. MATLAB Source Code for iris Biometric Identification                      %
% System Based on Iris Patterns. The School of Computer Science and Software Engineering,                   % 
% The University of Western Australia. 2003.                                                                %


%--------------For example-----------------%
 path = '.\face-iris'; 

 Generator_hidden_neuron=32;
 Discriminator_hidden_neuron=32;
 epoch = 50;
 learning_rate =0.00001;
%-----------------------------------------%

% ----------- intialize Data
intra_count=1;
inter_count=1;
count=0;
%------------ For each training Class --------------%
 
  content_folder = dir(path);
   for p= 3: numel(content_folder)              % Person _no  
       foldername = content_folder(p).name;
       folderPath=strcat(path,'\',foldername);
       if (exist(folderPath)==7)
       content_folder2 = dir(folderPath);
       disp(foldername);
       disp('-------------');
       if (numel(content_folder2)>=4)    % aperson must have both L & R
       
       [Left_first_train_sample,Right_first_train_sample,Left_Training_samples,Left_Training_samples_mean,Left_Permuted_sample,Right_Training_samples,Right_Training_samples_mean,Right_Permuted_sample,foldername2,face_first_train_sample,face_Training_samples,face_Training_samples_mean,face_Permuted_sample]= Read_data_Person(content_folder2,folderPath);
      
        count=count+1;
       Min=min([size(Left_Training_samples,1),size(Right_Training_samples,1),size(face_Training_samples,1)]);
       
       for i=1:Min
           S(i,:)=[Right_Training_samples(i,:),Left_Training_samples(i,:),face_Training_samples(i,:)];  
       end
            P=S(1,:);
            Permuted_sample= P(randperm(length(P)));
             M=mean(S(1:Min,:));     
            [Cancelabe_template,generator]= Training_GAN (Permuted_sample,S,M,Generator_hidden_neuron,Discriminator_hidden_neuron,epoch,learning_rate);
   
       
   %-----------------------Test_intra_inter-----------------------.%
        
   %-----------Intra Test--------------------
   content_folder_Test = dir(path);
   for p_Test=3: numel(content_folder_Test)        % person _no  
       foldername_Test = content_folder_Test(p_Test).name;
       folderPath_Test=strcat(path,'\',foldername_Test);
       if (exist(folderPath_Test)==7)
       content_folder2_Test = dir(folderPath_Test);
       if (numel(content_folder2_Test)>=4) 
              [Left_Testing_samples,Right_Testing_samples,face_Testing_samples] = Test_Data(content_folder2_Test,folderPath_Test);
              

%                        % ----Cancellable Test Template -------%

             for Left_Test=1:size(Left_Testing_samples,1)    
                for Right_Test=1:size(Right_Testing_samples,1) 
                    for face_Test=1:size(face_Testing_samples,1) 
                    disp(strcat(foldername,',,,,,,,',foldername_Test,'.......',num2str(Left_Test),',,,,,',num2str(Right_Test),',,,,,',num2str(face_Test)));
                    disp('-------------'); 
                   
                    S_test=[Right_Testing_samples(Right_Test,:),Left_Testing_samples(Left_Test,:),face_Testing_samples(face_Test,:)]; 

                    
                      generator_Test = nnff(generator, S_test);
                      Out_put = generator_Test.layers{generator_Test.layers_count}.a;% ----generator Test Template -------%
                   %----Binarized generator Test Template -------%
                         for jjjj=1:size(Out_put,2)
                          if Out_put(jjjj)>=0.5
                             Out_put(jjjj)=1;
                          else
                             Out_put(jjjj)=0;
                          end
                          end 
                     %  ----Cancellable Test Template -------%
            
                      Cancelable_Test= xor(Out_put,S_test);
                    
                         
                  if ( p_Test== p)
                     Intra_Distance(intra_count)=norm(Cancelabe_template-Cancelable_Test);
                      intra_count=intra_count+1;
                
                  else
                       Inter_Distance(inter_count)=norm(Cancelabe_template-Cancelable_Test);
                        inter_count=inter_count+1;
                      
                  end
              end
       end
                end
               end
           end  
           end
           end   
      end 
end
    hd_intra = Intra_Distance;
    hd_inter=Inter_Distance;
 
  
%        % -----------------Plot the intra and inter distribution --------%  
         [FAR,FRR,EER,d]=  EER_value_Draw_ED(Intra_Distance,Inter_Distance);
         disp(strcat('Equal Error Rate= ' , num2str(EER),'(%)'));
         disp(count);
        figure;
        [f,x] = ksdensity(Intra_Distance);
        [f1,x1] = ksdensity(Inter_Distance);
         plot(x,f,'b',x1,f1,'r');
         h = legend('intra-class','inter-class');
         xlabel('Hamming distance');
         ylabel('Frequency');
         
       %--------Find the system EER and plot the FAR and FRR system intersection and Draw the system ROC Curve-------%
         [FAR,FRR,EER,d]=  EER_value_Draw_ED(Intra_Distance,Inter_Distance);
         disp(strcat('Equal Error Rate= ' , num2str(EER),'(%)'));
         disp(count);

          path='.\Result.mat';
          save(path,'hd_intra','hd_inter');
         
end
         
         
          