function  Multi_biometrics_Bio_GAN_Decision_fusion()


%  GAN model for Securing Biometric authentication system version 1.0                                       %
% Main paper: "A keyless multimodal-based user authentication scheme using a generative adversarial network"  %
%                                                                                                          
Mayada Tarek Corresp , Eslam Hamouda  , Amjad Alsirhani  , Abdullah Alomari  , Ayman Mohamed Mostafa    
%                                                                                                           %
%   Based on code devloped by @JZhaoCH, https://github.com/JZhaoCH/Simple-GAN-Base-on-Matlab                %
% And, Libor Masek, Peter Kovesi. MATLAB Source Code for iris Biometric Identification                      %
% System Based on Iris Patterns. The School of Computer Science and Software Engineering,                   % 
% The University of Western Australia. 2003.                                                                %


%--------------For example-----------------%

   path='.\face-iris';
 Generator_hidden_neuron=32;
 Discriminator_hidden_neuron=32;
 epoch = 50;
 learning_rate =0.00001;
%-----------------------------------------%

% ----------- intialize Data
intra_count_Left=1;
inter_count_Left=1;

intra_count_Right=1;
inter_count_Right=1;

intra_count_face=1;
inter_count_face=1;
%------------ For each training Class --------------%
 
  content_folder = dir(path);
   for p=3:numel(content_folder)              % Person _no  
       foldername = content_folder(p).name;
       folderPath=strcat(path,'\',foldername);
       if (exist(folderPath)==7)
       content_folder2 = dir(folderPath);
       disp(foldername);
       disp('-------------');
       if (numel(content_folder2)>=4)    % aperson must have both L & R
       for real_f=3:numel(content_folder2)       % Left or Right   Eyes  
       foldername2 = content_folder2(real_f).name;
      
       if (foldername2 =='R')
         folderPath2=strcat(folderPath,'\',foldername2);
         if (exist(folderPath2)==7)
           contents = dir(folderPath2);
          %  if (length(contents)> 3)
                                     %-----------Compute samples mean and find permuted version(Salting key)--------%       
           
               [Permuted_sample_R,first_train_sample,Training_samples_R,Training_samples_mean_R]= Read_data_Person2(folderPath2);
              [Cancellable_template_Right,generator_Right]=GAN_Model(Permuted_sample_R,Training_samples_R,Training_samples_mean_R,Generator_hidden_neuron,Discriminator_hidden_neuron,epoch,learning_rate);
            end
       
       
       
   content_folder_Test = dir(path);
   for p_Test=3:numel(content_folder_Test)        % person _no  
       foldername_Test = content_folder_Test(p_Test).name;
       folderPath_Test=strcat(path,'\',foldername_Test);
       if (exist(folderPath_Test)==7)
       content_folder2_Test = dir(folderPath_Test);
       if (numel(content_folder2_Test)>=4) 
              [Left_Testing_samples,Right_Testing_samples,face_Testing_samples] = Test_Data(content_folder2_Test,folderPath_Test);
              
               
                for Right_Test=1:size(Right_Testing_samples,1) 
          
                  generator_Test = nnff(generator_Right, Right_Testing_samples(Right_Test,:));
                  Out_put = generator_Test.layers{generator_Test.layers_count}.a;% ----generator Test Template -------%
                   % ----Binarized generator Test Template -------%
                         for jjjj=1:size(Out_put,2)
                          if Out_put(jjjj)>=0.5
                             Out_put(jjjj)=1;
                          else
                             Out_put(jjjj)=0;
                          end
                          end 
                       % ----Cancellable Test Template -------%
                         Out_put_Right=xor(Out_put,Right_Testing_samples(Right_Test,:));      
                       Cancellable_Test_Right= [Out_put_Right];
                           
                        
                         
                  if ( p_Test== p)
                     Intra_Distance_Right(intra_count_Right)=norm(Cancellable_Test_Right-Cancellable_template_Right);
                      intra_count_Right=intra_count_Right+1;
                
                  else
                       Inter_Distance_Right(inter_count_Right)=norm(Cancellable_Test_Right-Cancellable_template_Right);
                        inter_count_Right=inter_count_Right+1;
                      
                  end
              end
       end
                end
               end
             
      end 
     
       if (foldername2 =='L')
       folderPath2=strcat(folderPath,'\',foldername2);
        if (exist(folderPath2)==7)
           contents = dir(folderPath2);
           % if (length(contents)> 3)
                                     %-----------Compute samples mean and find permuted version(Salting key)--------%       
           
               [Permuted_sample_L,first_train_sample,Training_samples_L,Training_samples_mean_L]= Read_data_Person2(folderPath2);
              [ Cancellable_template_Left,generator_Left]=GAN_Model(Permuted_sample_L,Training_samples_L,Training_samples_mean_L,Generator_hidden_neuron,Discriminator_hidden_neuron,epoch,learning_rate);
       end
    
       
    content_folder_Test = dir(path);
   for p_Test=3:numel(content_folder_Test)        % person _no  
       foldername_Test = content_folder_Test(p_Test).name;
       folderPath_Test=strcat(path,'\',foldername_Test);
       if (exist(folderPath_Test)==7)
       content_folder2_Test = dir(folderPath_Test);
       if (numel(content_folder2_Test)>=4) 
              [Left_Testing_samples,Right_Testing_samples,face_Testing_samples] = Test_Data(content_folder2_Test,folderPath_Test);
              
                  for Left_Test=1:size(Left_Testing_samples,1)       %Left or Right   Eyes  
                  generator_Test = nnff(generator_Left,Left_Testing_samples(Left_Test,:));
                  Out_put = generator_Test.layers{generator_Test.layers_count}.a;% ----generator Test Template -------%
                   % ----Binarized generator Test Template -------%
                         for jjjj=1:size(Out_put,2)
                          if Out_put(jjjj)>=0.5
                             Out_put(jjjj)=1;
                          else
                             Out_put(jjjj)=0;
                          end
                          end 
                       % ----Cancellable Test Template -------%
                        Out_put_Left=xor(Out_put,Left_Testing_samples(Left_Test,:));             
                        
                       Cancellable_Test_Left= [Out_put_Left];
                                   
                  if ( p_Test== p)
                     Intra_Distance_Left(intra_count_Left)=norm(Cancellable_Test_Left-Cancellable_template_Left);
                      intra_count_Left=intra_count_Left+1;
                
                  else
                       Inter_Distance_Left(inter_count_Left)=norm(Cancellable_Test_Left-Cancellable_template_Left);
                        inter_count_Left=inter_count_Left+1;
                      
                  end
              end
       end
                end
               end
           end  
           
              
   
        if (foldername2 =='F')
       folderPath2=strcat(folderPath,'\',foldername2);
        if (exist(folderPath2)==7)
           contents = dir(folderPath2);
           % if (length(contents)> 3)
                                     %-----------Compute samples mean and find permuted version(Salting key)--------%       
           
               [Permuted_sample_face,first_train_sample,Training_samples_face,Training_samples_mean_face]= Read_data_Person_face(folderPath2);
              [ Cancellable_template_face,generator_face]=GAN_Model(Permuted_sample_face,Training_samples_face,Training_samples_mean_face,Generator_hidden_neuron,Discriminator_hidden_neuron,epoch,learning_rate);
       end
       
       
   content_folder_Test = dir(path);
   for p_Test=3:numel(content_folder_Test)        % person _no  
       foldername_Test = content_folder_Test(p_Test).name;
       folderPath_Test=strcat(path,'\',foldername_Test);
       if (exist(folderPath_Test)==7)
       content_folder2_Test = dir(folderPath_Test);
       if (numel(content_folder2_Test)>=4) 
              [Left_Testing_samples,Right_Testing_samples,face_Testing_samples] = Test_Data(content_folder2_Test,folderPath_Test);
                     
                for face_Test=1:size(face_Testing_samples,1)      
                  generator_Test = nnff(generator_face, face_Testing_samples(face_Test,:));
                  Out_put = generator_Test.layers{generator_Test.layers_count}.a;% ----generator Test Template -------%
                   % ----Binarized generator Test Template -------%
                         for jjjj=1:size(Out_put,2)
                          if Out_put(jjjj)>=0.5
                             Out_put(jjjj)=1;
                          else
                             Out_put(jjjj)=0;
                          end
                          end 
                       % ----Cancellable Test Template -------%
                         Out_put_face=xor(Out_put,face_Testing_samples(face_Test,:));           
                      
                       Cancellable_Test_face= [Out_put_face];
                           
                        
                         
                  if ( p_Test== p)
                     Intra_Distance_face(intra_count_face)=norm(Cancellable_Test_face-Cancellable_template_face);
                      intra_count_face=intra_count_face+1;
                
                  else
                       Inter_Distance_face(inter_count_face)=norm(Cancellable_Test_face-Cancellable_template_face);
                        inter_count_face=inter_count_face+1;
                      
                  end
              end
       end
                end
               end
           end  
           end
           end   
       end 
   end
   
   [Seta_Left,FAR,FRR,EER,d]=  EER_value_Draw_ED2(Intra_Distance_Left,Inter_Distance_Left);
   [Seta_Right,FAR,FRR,EER,d]=  EER_value_Draw_ED2(Intra_Distance_Right,Inter_Distance_Right);
   [Seta_face,FAR,FRR,EER,d]=  EER_value_Draw_ED2(Intra_Distance_face,Inter_Distance_face);

%        % -----------------Plot the intra and inter distribution --------%       
        figure;
        [f,x] = ksdensity(Intra_Distance);
        [f1,x1] = ksdensity(Inter_Distance);
         plot(x,f,'b',x1,f1,'r');
         h = legend('intra-class','inter-class',2);
         xlabel('Hamming distance');
         ylabel('Frequency');
         
       %--------Find the system EER and plot the FAR and FRR system intersection and Draw the system ROC Curve-------%
         [FAR,FRR,EER,d]=  EER_value_Draw_ED(Intra_Distance,Inter_Distance);
         disp(strcat('Equal Error Rate= ' , num2str(EER),'(%)'));
         
end
         
         
          