% Generator bp
function g_net = nnbp_g(g_net, d_net)
    n = g_net.layers_count;
    a = g_net.layers{n}.a;
    % generator's loss is obtained by label_fake, (images_fake over discriminator gets label_fake) 
    % When g is bp, you can think of g and d as a whole The residual of the last layer of 
    % g is equal to the residual of the second layer of d multiplied by (a .* (a_o))
    g_net.layers{n}.d = d_net.layers{2}.d * d_net.layers{2}.w' .* (a .* (1-a));
    for i = n-1:-1:2
        d = g_net.layers{i+1}.d;
        w = g_net.layers{i+1}.w;
        z = g_net.layers{i}.z;
% The residual of each layer is the partial derivative of the inactive value of each layer, so the residual of the latter layer is multiplied by w, 
%and then multiplied by the partial derivative of the activation value to the inactive value.
        g_net.layers{i}.d = d*w' .* delta_relu(z);    
    end
    % After finding the residual of each layer, we can find the partial derivative of the final loss to weights and bias based on the residual.
    for i = 2:n
        d = g_net.layers{i}.d;
        a = g_net.layers{i-1}.a;
        % dw is the solution to the partial derivative of the weights of each layer
        g_net.layers{i}.dw = a'*d / size(d, 1);
        g_net.layers{i}.db = mean(d, 1);
    end
end