% % Establish a network based on the given structure
function nn = nnsetup(architecture)
    nn.architecture   = architecture;
    nn.layers_count = numel(nn.architecture);
    % t,beta1,beta2,epsilon,nn.layers{i}.w_m,nn.layers{i}.w_v,nn.layers{i}.b_m,nn.layers{i}.b_v Is the variable required to update the network using the adam algorithm
    nn.t = 0;
    nn.beta1 = 0.9;
    nn.beta2 = 0.999;
    nn.epsilon = 10^(-8);
% Assuming the structure is [100, 512, 784], there are 3 layers, the input layer 100, and two hidden layers: 
% 100*512, 512*784, and the output is the a value of the last layer (activation value).
    for i = 2 : nn.layers_count   
       nn.layers{i}.w = normrnd(0, 0.02, nn.architecture(i-1), nn.architecture(i));
       nn.layers{i}.b = normrnd(0, 0.02, 1, nn.architecture(i));
        nn.layers{i}.w_m = 0;
        nn.layers{i}.w_v = 0;
        nn.layers{i}.b_m = 0;
        nn.layers{i}.b_v = 0;
    end
end
