function [mu,s,n,Data]=normrnd_normfit(MU,SIGMA,Length_Data,nb_bins)
%normrnd_normfit helps the user generate a normally distributed random set
%of data and then fit a Gaussian curve on the top of the data and back
%compute its mean and standard deviation. It helps the user check if NORMRND 
%function did its job.It plots the original histogram and the fitted one.
%normrnd_normfit uses two Matlab(R) functions: NORMRND and HIST.
%Inputs:
%         MU: mean of the data. It is a 1D vector
%         SIGMA: standard deviation of the data. It is a scalar
%         Length_Data(optional): the length of the random vector to be generated
%         nb_bins(optional): number of bins for the histogram.
%Outputs:
%         mu: computed mean of the generated 1D random vector
%         s: standard deviation of the generated 1D random vector
%         Data: the generated 1D random vector.
%Example: 
%        [mu,s,n,xout]=normrnd_normfit(1,.05,1000,20);
% or 
%        [mu,s,n,xout]=normrnd_normfit(1,.05);
% or 
%        [mu,s,n,xout]=normrnd_normfit;
%This function is written by Nassim Khaled, Ph.D.


%example for the user in case no inputs have been provided to the funtion
%normrnd_normfit
if nargin==0
    MU=1; SIGMA=0.05; Length_Data=1000; nb_bins=10;
elseif nargin==2
     Length_Data=1000; nb_bins=10;
end
%generate 1D normally distributed random vector    
Data=normrnd(MU.*ones(Length_Data,1),SIGMA);
figure
% plot the data
hist(Data,nb_bins);
%compute the frequencies(to be used to compute maximum frequency to 
%normalize the figure)
[n,xout]=hist(Data,nb_bins);
%find the normal fit for the data
[mu,s] = normfit(Data);
%normalized Gaussian Formula 
y=inline('exp(-(x-mu).^2./(2*s.^2))');

hold on
%generate a longer vector to make a cleare
xout_extended=min(Data)-3.*SIGMA:abs(MU)./(nb_bins+146):max(Data)+3.*SIGMA;
plot(xout_extended,max(n).*y(mu,s,xout_extended),'LineWidth',4,'Color','r')
legend('NORMRAND','Gaussian fit')
hold off