from node2vec import Node2Vec
def create_node_embeddings(G, dimensions=128, walk_length=20, num_walks=40, p=1, q=1, workers=4):
    """
    Creating node embeddings using node2vec
    """
    node2vec = Node2Vec(G,
                        dimensions=dimensions,
                        walk_length=walk_length,
                        num_walks=num_walks,
                        p=p,
                        q=q,
                        workers=workers)

    # Training the model.
    model = node2vec.fit(window=10, min_count=1)

    # Get the embedding vectors of all nodes
    embeddings = {}
    for node in G.nodes():
        embeddings[node] = model.wv[str(node)]

    return embeddings
