import networkx as nx
def calculate_node_importance(G):
    """
    Compute node importance
    A combined measure of normalized degree centrality (DC), PageRank(PR), and clustering coefficient (CC) is used
    NI(i) = DC_norm(i) * PR_norm(i) * (1 + CC_norm(i))
    """
    importance = {}

    # 1. Calculate three indicators
    # Degree centrality
    dc_values = dict(nx.degree_centrality(G))
    max_dc = max(dc_values.values())

    # PageRank Value
    pr_values = dict(nx.pagerank(G))
    max_pr = max(pr_values.values())

    # Clustering coefficient
    cc_values = dict(nx.clustering(G))
    max_cc = max(cc_values.values()) if cc_values.values() else 1.0 

    # 2. Normalized processing and calculation of comprehensive importance
    for node in G.nodes():
        #Normalization of indicators
        dc_norm = dc_values[node] / max_dc
        pr_norm = pr_values[node] / max_pr
        cc_norm = cc_values.get(node, 0) / max_cc

        # Compute node importance
        importance[node] = dc_norm * pr_norm * (1 + cc_norm)

    return importance
