"""
For all the files in the input directory,
compile them with the option
/opt/homebrew/opt/llvm@14/bin/clang -std=c89 --target=x86_64-none-none \
-Wno-everything -Wdeclaration-after-statement -c -o /dev/null
to check for variable declarations after statements.
"""

import os
import subprocess

input_directory = "downloaded_benchmarks"
output_file = "check_var_decls_output.txt"

file_with_issues = []

if os.path.exists(output_file):
    os.remove(output_file)

with open(output_file, "w") as f:
    for path, folders, files in os.walk(input_directory):
        for file_name in files:
            f.write(f"File: {file_name}\n")
            command = f"/opt/homebrew/opt/llvm@14/bin/clang -std=c89 --target=x86_64-none-none -Wno-everything -Wdeclaration-after-statement -c -o /dev/null {input_directory}/{file_name}"
            return_code, output = subprocess.getstatusoutput(command)
            if return_code == 0:
                print(f"File {file_name} compiles successfully.")
            else:
                print(f"File {file_name} does not compile.")
            if output:
                file_with_issues.append(file_name)
                f.write(output)
            f.write("\n")
        break
print("Files with issues:")
print(len(file_with_issues))



