#!/bin/bash

if test $# -ne 4
then
   echo "Usage: compare-precision.sh JSON_DIR1 JSON_DIR2 OUTPUT_FILE"
   return -1
fi

JSON_DIR1=$1
JSON_DIR2=$2
OUTPUT_FILE=$3

>$OUTPUT_FILE

for TEST1 in $JSON_DIR1/*havoc*.json
do
    BASE=`basename $TEST1`
    #TEST2=$JSON_DIR2/$BASE
    TEST2="$JSON_DIR2/${BASE/.havoc/}"
    echo "Comparing precision of $TEST1 and $TEST2 ..."
    echo "Comparing precision of $TEST1 and $TEST2 ..." >> $OUTPUT_FILE
    clam-diff --semdiff --dom=int --verbose=2 $TEST1 $TEST2 >> $OUTPUT_FILE 2>&1
done
