#!/bin/bash

# NOTA: perché lo script funzioni va scommentata la riga
#   m_cfg->dumpCfgStats();
# nel file lib/Clam/CfgBuilder.cc (e ricompilato clam)

clam_noinline='clam.py --crab-havoc-analysis=pos-nonrel --crab-dom=int'
clam_inline='clam.py --inline --crab-havoc-analysis=pos-nonrel --crab-dom=int'

path=driver_info.csv
rm -rf $path

echo "driver;fun;var;node;stmt;fun;var;node;stmt" > $path

for driver in ../downloaded_benchmarks/drivers/*
do
  # driver name
  echo -n $driver >> $path

  # WITHOUT inlining
  $clam_noinline $driver 2>/dev/null > OUTPUT

  # number of functions
  funcs=$(fgrep "cfg for function" OUTPUT | wc -l)
  echo -n ";" $funcs >> $path

  # number of numeric vars
  vars=$(fgrep "Cardinality of CFG_NUMERIC_VARS" OUTPUT | cut -d ' ' -f 9 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $vars >> $path

  # number of cfg blocks
  blocks=$(fgrep "#EZ# nodes" OUTPUT | cut -d ' ' -f 4 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $blocks >> $path

  # number of stmts
  stmts=$(fgrep  "Number of initial statements" OUTPUT | cut -d ' ' -f 6 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $stmts >> $path

  # WITH inlining
  $clam_inline $driver 2>/dev/null > OUTPUT

  # number of functions
  funcs=$(fgrep "cfg for function" OUTPUT | wc -l)
  echo -n ";" $funcs >> $path

  # number of numeric vars
  vars=$(fgrep "Cardinality of CFG_NUMERIC_VARS" OUTPUT | cut -d ' ' -f 9 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $vars >> $path

  # number of cfg blocks
  blocks=$(fgrep "#EZ# nodes" OUTPUT | cut -d ' ' -f 4 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $blocks >> $path

  # number of stmts
  stmts=$(fgrep  "Number of initial statements" OUTPUT | cut -d ' ' -f 6 | awk '{ sum += $1 } END { print sum }')
  echo -n ";" $stmts >> $path

  rm OUTPUT

  echo "" >> $path
done
