import argparse
from train import train_single_image

def main():
    parser = argparse.ArgumentParser(description='Hierarchical Multi-Scale GAN Training for Watercolor Paintings')
    parser.add_argument('--img_path', type=str, required=True, help='Path to input image')
    parser.add_argument('--N', type=int, default=5, help='Number of scales (default: 5)')
    parser.add_argument('--r', type=float, default=0.75, help='Downsample ratio per scale (default: 0.75)')
    parser.add_argument('--ch', type=int, default=32, help='Number of channels in generator/discriminator (default: 32)')
    parser.add_argument('--noise_ch', type=int, default=3, help='Noise channels (default: 3)')
    parser.add_argument('--alpha', type=float, default=10, help='Reconstruction loss weight (default: 10)')
    parser.add_argument('--iters', type=int, default=2000, help='Iterations per scale (default: 2000)')
    parser.add_argument('--save_dir', type=str, default='output', help='Directory to save outputs')
    args = parser.parse_args()

    print(f"Training on image: {args.img_path}")
    train_single_image(
        img_path=args.img_path,
        N=args.N,
        r=args.r,
        ch=args.ch,
        noise_ch=args.noise_ch,
        alpha=args.alpha,
        iters=args.iters,
        save_dir=args.save_dir
    )

 