from PIL import Image
import torch
import torchvision.transforms as T

def load_image(path):
    img = Image.open(path).convert('RGB')
    return T.ToTensor()(img).unsqueeze(0)

def save_tensor_img(tensor, path):
    img = T.ToPILImage()(tensor.squeeze(0).cpu())
    img.save(path) 