# Gunner
Gunner is an enhanced version of Arnold.

### This repository contains:
- The source code to train Gunner agent


## Installation

#### Dependencies
Gunner was tested successfully on Mac OS and Linux distributions. You will need:
- Python 2/3 with NumPy and OpenCV
- PyTorch
- ViZDoom


## Code structure

    .
    ├── pretrained                    # Examples of pretrained models
    ├── resources
        ├── freedoom2.wad             # DOOM resources file (containing all textures)
        └── scenarios                 # Folder containing all scenarios
            ├── full_deathmatch.wad   # Scenario containing all deathmatch maps
            ├── health_gathering.wad  # Simple test scenario
            └── ...
    ├── src                           # Source files
        ├── doom                      # Game interaction / API / scenarios
        ├── model                     # DQN / DRQN / Gunner implementations
        └── trainer                   # Folder containing training scripts
    ├── atom.py                       # Main file
    └── README.md


## References

[1] G. Lample\* and D.S. Chaplot\*, [*Playing FPS Games with Deep Reinforcement Learning*](https://arxiv.org/abs/1609.05521)
```
@inproceedings{lample2017playing,
  title={Playing FPS Games with Deep Reinforcement Learning.},
  author={Lample, Guillaume and Chaplot, Devendra Singh},
  booktitle={Proceedings of AAAI},
  year={2017}
}
```


[2] D.S. Chaplot\* and G. Lample\*, [*Arnold: An Autonomous Agent to Play FPS Games*](http://www.cs.cmu.edu/~dchaplot/papers/arnold_aaai17.pdf)
```
@inproceedings{chaplot2017arnold,
  title={Arnold: An Autonomous Agent to Play FPS Games.},
  author={Chaplot, Devendra Singh and Lample, Guillaume},
  booktitle={Proceedings of AAAI},
  year={2017},
  Note={Best Demo award}
}
```
