library(limma)
library(GSEABase)
library(GSVA)
library(pheatmap)

expFile="merge.txt"         
riskFile="risk.all.txt"     
gmtFile="h.all.v2022.1.Hs.symbols.gmt"    

rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)

geneSets=getGmt(gmtFile, geneIdType=SymbolIdentifier())
gsvaResult=gsva(data, 
                geneSets, 
                min.sz=10, 
                max.sz=500, 
                verbose=TRUE,
                parallel.sz=1)

data=t(gsvaResult)
group=sapply(strsplit(row.names(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2", "1", group)
data=data[group==0,]
row.names(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-.*", "\\1\\-\\2\\-\\3", row.names(data))
data=avereps(data)

risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)

sameSample=intersect(row.names(data), row.names(risk))
data=data[sameSample,,drop=F]
risk=risk[sameSample,"risk",drop=F]
gsvarisk=cbind(data, risk)

con=gsvarisk[gsvarisk$risk=="low",]
treat=gsvarisk[gsvarisk$risk=="high",]
data=rbind(con, treat)

Type=as.vector(data$risk)
Type=factor(Type, levels=c("low", "high"))
ann=data[,ncol(data),drop=F]
data=t(data[,-ncol(data),drop=F])
design=model.matrix(~0+factor(Type))
colnames(design)=levels(factor(Type))
fit=lmFit(data, design)
cont.matrix=makeContrasts(high-low, levels=design)
fit2=contrasts.fit(fit, cont.matrix)
fit2=eBayes(fit2)

allDiff=topTable(fit2,adjust='fdr',number=200000)
allDiffOut=rbind(id=colnames(allDiff),allDiff)
write.table(allDiffOut, file="all.txt", sep="\t", quote=F, col.names=F)

#??????????????ͨ·
diffSig=allDiff[with(allDiff, (abs(logFC)>0.1 & adj.P.Val < 0.05)), ]
diffSigOut=rbind(id=colnames(diffSig), diffSig)
write.table(diffSigOut, file="diff.txt", sep="\t", quote=F, col.names=F)

ann_colors=list()
bioCol=c("blue", "red")
names(bioCol)=c("low", "high")
ann_colors[["Risk"]]=bioCol

termNum=50    
diffTermName=as.vector(rownames(diffSig))
diffLength=length(diffTermName)
if(diffLength<termNum){termNum=diffLength}
hmGene=diffTermName[1:termNum]
hmExp=data[hmGene,]
pdf(file="heatmap.pdf", width=10, height=6)
pheatmap(hmExp, 
	     annotation=ann,
	     annotation_colors = ann_colors,
	     color = colorRampPalette(c(rep("blue",3), "white", rep("red",3)))(50),
	     cluster_cols=F,
	     show_colnames = F,
	     gaps_col=as.vector(cumsum(table(Type))),
	     scale="row",
	     fontsize = 7,
	     fontsize_row=6,
	     fontsize_col=7)
dev.off()

