
#install.packages("ggpubr")


library(ggpubr)
riskFile="risk.all.txt"     
mutFile="mutMatrix.txt"     
mutGene="CDKN2A"               

risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk$riskScore[risk$riskScore>quantile(risk$riskScore,0.99)]=quantile(risk$riskScore,0.99)

mut=read.table(mutFile, header=T, sep="\t", check.names=F, row.names=1)
mut=t(mut[mutGene,,drop=F])
colnames(mut)=c("Type")

sameSample=intersect(row.names(mut), row.names(risk))
mut=mut[sameSample,,drop=F]
risk=risk[sameSample,,drop=F]
data=cbind(as.data.frame(risk), as.data.frame(mut))
data$Type=paste0(mutGene, " " , data$Type)

data$Type=factor(data$Type, levels=c(paste0(mutGene, " 0"), paste0(mutGene, " 1")) )
group=levels(factor(data$Type))
comp=combn(group,2)
my_comparisons=list()
for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}

data1=data[,c("riskScore", "Type")]
boxplot=ggviolin(data1, x="Type", y="riskScore", fill="Type",
				  xlab="",
				  ylab="Risk score",
				  legend.title="",
				  add = "jitter",
				  palette=c("#0066FF","#FF0000") , add.params = list(fill="white"))+ 
	stat_compare_means(comparisons = my_comparisons)

boxplot=ggboxplot(data1, x="Type", y="riskScore", fill="Type",
                  xlab="",
                  ylab="Risk score",
                  legend.title="",
                  add = "jitter")+ 
  stat_compare_means(comparisons = my_comparisons)	

pdf(file=paste0(mutGene, ".pdf"), width=5, height=4.5)
print(boxplot)
dev.off()

