#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install(c("limma", "car", "ridge", "preprocessCore", "genefilter", "sva", "biomaRt"))
#BiocManager::install("GenomicFeatures", "maftools", " stringr", "org.Hs.eg.db")
#BiocManager::install("TxDb.Hsapiens.UCSC.hg19.knownGene")

#install.packages("oncoPredict")


#ð
library(limma)
library(oncoPredict)
library(parallel)
set.seed(12345)

expFile="symbol.txt"     #ļ
setwd("C:\\Users\\lexb\\Desktop\\macrophage\\37.oncoPredict")     #ùĿ¼

#ȡļ,ݽд
rt = read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp), colnames(exp))
data=matrix(as.numeric(as.matrix(exp)), nrow=nrow(exp), dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0.5,]

#ɾƷ
group=sapply(strsplit(colnames(data),"\\-"), "[", 4)
group=sapply(strsplit(group,""), "[", 1)
group=gsub("2","1",group)
data=data[,group==0]
data=t(data)
rownames(data)=gsub("(.*?)\\-(.*?)\\-(.*?)\\-(.*?)\\-(.*)", "\\1\\-\\2\\-\\3", rownames(data))
data=avereps(data)
data=t(data)

#ȡҩļ
GDSC2_Expr=readRDS(file='GDSC2_Expr.rds')
GDSC2_Res=readRDS(file = 'GDSC2_Res.rds')
GDSC2_Res=exp(GDSC2_Res) 

#ҩ
calcPhenotype(trainingExprData = GDSC2_Expr,
              trainingPtype = GDSC2_Res,
              testExprData = data,
              batchCorrect = 'eb',      #"eb" for ComBat  
              powerTransformPhenotype = TRUE,
              removeLowVaryingGenes = 0.2,
              minNumSamples = 10, 
              printOutput = TRUE, 
              removeLowVaringGenesFrom = 'rawData')


######ѧ: https://www.biowolf.cn/
######γ1: https://shop119322454.taobao.com
######γ2: https://ke.biowolf.cn
######γ3: https://ke.biowolf.cn/mobile
######⿡ʦ: seqbio@foxmail.com
######⿡ʦ΢: eduBio

