#install.packages("fmsb")


library(fmsb)      #???ð?
inputFile="radarInput.txt"      #?״?ͼ???????ļ?
diffFile="diff.txt"             #?????Ľ????ļ?
setwd("D:/Study/#Shengxin/#disulfidptosis/disulfidptosis/45.modelImmune/27.radar")      #???ù???Ŀ¼

#??ȡ?????ļ?
data=read.table(inputFile, header=T, sep="\t", row.names=1, check.names=F)
data=rbind(rep(max(data),22), rep(0,22), data)

#????????ϸ????˳??
sortCellNames= c("B cells memory",
			    "B cells naive",              
				"Dendritic cells activated",
				"Dendritic cells resting",     
				"Eosinophils",
				"Macrophages M0",              
				"Macrophages M1",
				"Macrophages M2",              
				"Mast cells activated",
				"NK cells resting",            
				"Plasma cells",
				"Mast cells resting", 
				"T cells CD4 memory activated",
				"T cells CD4 naive", 
				"T cells CD4 memory resting",        
				"Monocytes",
				"Neutrophils",                 
				"NK cells activated",           
				"T cells CD8","T cells follicular helper",   
				"T cells gamma delta",
				"T cells regulatory (Tregs)")
data=data[,sortCellNames]

#??ȡ?????Ľ????ļ?,??????????
corStat=read.table(diffFile, header=T, sep="\t", check.names=F, row.names=1)
corStat=corStat[sortCellNames,]
colnames(data)=paste0(colnames(data), corStat$sig)

#?????״?ͼ
pdf(file="radar.pdf", width=10, height=10)
radarchart(data  , axistype=1 , 
	pcol=c("blue", "red"),       #??????ɫ
	plwd=2,                      #????????
	plty=1,                      #ѡ??????(2)??ʵ??(1)
	cglcol="grey",               #??????????ɫ
	cglty=1,                     #????????ѡ??????(2)??ʵ??(1)
	cglwd=0.8,                   #??????????ϸ 
	caxislabels=seq(0,1,0.05),   #?????Ŀ̶?
	axislabcol="grey",           #?̶???ɫ
	vlcex=1                   #??????С
   )
legend("topright", legend=rownames(data[-c(1,2),]), bty = "n", pch=20 , col=c("blue", "red") ,cex=1.2, pt.cex=2)
dev.off()


######??????ѧ??: https://www.biowolf.cn/
######?γ???1: https://shop119322454.taobao.com
######?γ???2: https://ke.biowolf.cn
######?γ???3: https://ke.biowolf.cn/mobile
######?⿡??ʦ????: seqbio@foxmail.com
######?⿡??ʦ΢??: eduBio

