library(limma)
library(ggpubr)

riskFile="risk.all.txt"      
cliFile="clinical.txt"           

risk=read.table(riskFile, header=T, sep="\t", check.names=F, row.names=1)
risk$riskScore[risk$riskScore>quantile(risk$riskScore,0.99)]=quantile(risk$riskScore,0.99)
cli=read.table(cliFile, header=T, sep="\t", check.names=F, row.names=1)
cli[,"Age"]=ifelse(cli[,"Age"]=="unknow", "unknow", ifelse(cli[,"Age"]>65,">65","<=65"))

samSample=intersect(row.names(risk), row.names(cli))
risk=risk[samSample,"riskScore",drop=F]
cli=cli[samSample,,drop=F]
rt=cbind(risk, cli)

for(clinical in colnames(rt[,2:ncol(rt)])){
	data=rt[c("riskScore", clinical)]
	colnames(data)=c("riskScore", "clinical")
	data=data[(data[,"clinical"]!="unknow"),]
	#???ñȽ???
	group=levels(factor(data$clinical))
	data$clinical=factor(data$clinical, levels=group)
	comp=combn(group,2)
	my_comparisons=list()
	for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}
	#????????ͼ
	boxplot=ggboxplot(data, x="clinical", y="riskScore", color="clinical",
		          xlab=clinical,
		          ylab="Risk score",
		          legend.title=clinical,
		          add = "jitter")+ 
	    stat_compare_means(comparisons = my_comparisons)
	    stat_compare_means(comparisons = my_comparisons,symnum.args=list(cutpoints = c(0, 0.001, 0.01, 0.05, 1), symbols = c("***", "**", "*", "ns")),label = "p.signif")
	pdf(file=paste0("cliCor.", clinical, ".pdf"), width=5.5, height=5)
	print(boxplot)
	dev.off()
}

