
// Dr. Feras Al-Obeidat
// March 2025


public class Individual {
	public int rank;
	double[][][] ThresholdsBefore;
	double fitness;
	double[][] data;
	double d1, S1, S2, d2;
	double[][][][] Thresholds;
	double[][][] Weights; // [class][prototype][attribute]


	public double[][][][] getThresholds() {
		return Thresholds;
	}

	public void setThresholds(double[][][][] thresholds) {
		Thresholds = thresholds;
	}

	

	public Individual(double[][][][] Thresholds, double[][][] Weights, double[][] data) {
	    if (Thresholds == null || Weights == null || data == null)
	        throw new IllegalArgumentException("Thresholds, Weights, and data must not be null.");

	    this.Thresholds = Thresholds;
	    this.Weights = Weights;
	    this.data = data;
	    this.fitness = fitnessFunction(Thresholds, Weights, data);
	}

	

	// Update fitness function to use weights
	public double fitnessFunction(double[][][][] Thresholds, double[][][] Weights, double[][] data) {
	    int numOfClasses = Thresholds.length;
	    int numOfPrototypes = Thresholds[0].length;
	    int numOfAttributes = Thresholds[0][0].length;
	    double[] maxPro = new double[numOfClasses];
	    double[] I = new double[numOfPrototypes];
	    double concordance, partialIndifference, maxValue;
	    double unrecognizedClassified = 0;
	    int indexClass, numberOfErrorClassfication = 0;

	    for (double[] element : data) {
	        for (int cl = 0; cl < numOfClasses; cl++) {
	            for (int p = 0; p < numOfPrototypes; p++) {
	                concordance = 0;
	                for (int att = 0; att < numOfAttributes; att++) {
	                    partialIndifference = M(Thresholds[cl][p][att], element[att]);
	                    concordance += Weights[cl][p][att] * partialIndifference;
	                }
	                I[p] = concordance / numOfAttributes;
	            }
	            maxPro[cl] = max(I);
	        }

	        maxValue = max(maxPro);
	        indexClass = indx(maxPro, maxValue);
	        if (indexClass == -1) {
	            unrecognizedClassified++;
	            continue;
	        }
	        if (indexClass != (int) element[numOfAttributes])
	            numberOfErrorClassfication++;
	    }

	    return (data.length - unrecognizedClassified - numberOfErrorClassfication) / (data.length) * 100;
	}

	// You would also need to update optimizeParameters and pheromone updates accordingly to handle the weights alongside thresholds.


	public double M(double[] Thresholds, double a) {
		double d1 = Thresholds[0];
		double S1 = Thresholds[1];
		double S2 = Thresholds[2];
		double d2 = Thresholds[3];

		if (a >= S1 && a <= S2)
			return 1;
		else if (a <= (S1 - d1) || a >= (S2 + d2))
			return 0;
		else {
			double cMinus = (d1 - Math.min(S1 - a, d1)) / (d1 - Math.min(S1 - a, 0));
			double cPlus = (d2 - Math.min(a - S2, d2)) / (d2 - Math.min(a - S2, 0));
			return Math.min(cMinus, cPlus);
		}
	}

	public double max(double[] t) {
		double maximum = t[0];
		for (int i = 1; i < t.length; i++) {
			if (t[i] > maximum)
				maximum = t[i];
		}
		return maximum;
	}

	public int indx(double[] t, double val) {
		int firstVal = -1, c = 0;
		for (int i = 0; i < t.length; i++) {
			if (t[i] == val) {
				firstVal = i;
				c++;
			}
		}
		return (c == 1) ? firstVal : -1;
	}
	
	public double[][][] getWeights() {
		return Weights;
	}

}
