// Dr. Feras Al-Obeidat
// March 2025


import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ThresholdUtil {
	public static double[][][] stdDevs; // [class][prototype][attribute]


	public static double[][][][] compute(double[][] trainData, int numClasses, int numOfProt, int numAttrs, int D) {
		double[][][][] thresholds = new double[numClasses][numOfProt][numAttrs - 1][D];
		stdDevs = new double[numClasses][numOfProt][numAttrs - 1];

		for (int cl = 0; cl < numClasses; cl++) {
			for (int p = 0; p < numOfProt; p++) {
				for (int at = 0; at < numAttrs - 1; at++) {
					List<Double> values = new ArrayList<>();
					for (double[] row : trainData) {
						if ((int) row[numAttrs - 1] == cl) {
							values.add(row[at]);
						}
					}

					double[] vals = values.stream().mapToDouble(d -> d).toArray();
					double mean = mean(vals); 
					double std = stdDev(vals);
					
					stdDevs[cl][p][at] = std;

					thresholds[cl][p][at][0] = 2 * std; // d1 
					thresholds[cl][p][at][1] = mean - 2 * std; // s1 
					thresholds[cl][p][at][2] = mean + 2 * std; // s2
					thresholds[cl][p][at][3] = 2 * std; // d2
				}
			}
		}
		return thresholds;

	}
	private static double mean(double[] vals) {
		return Arrays.stream(vals).average().orElse(0.0);
	}

	private static double stdDev(double[] vals) {
		double avg = mean(vals);
		return Math.sqrt(Arrays.stream(vals).map(v -> (v - avg) * (v - avg)).sum() / vals.length);
	}
	
	public static double percentile(double[] values, double percentile) {
	    Arrays.sort(values);
	    int index = (int) Math.ceil(percentile / 100.0 * values.length);
	    return values[Math.min(index, values.length - 1)];
	}

}
