class Decodemesh():
    def __init__(self, config) -> None:
        self.start_lon = config['start_longitude']
        self.stop_lon = config['stop_longitude']
        self.start_lat = config['start_latitude']
        self.stop_lat = config['stop_latitude']

        self.longitude_lenth = config['longitude_lenth']
        self.latitude_lenth = config['latitude_lenth']

        self.scale = config['scale']

        self.lon_step = (self.stop_lon - self.start_lon) / self.longitude_lenth
        self.lat_step = (self.stop_lat - self.start_lat) / self.latitude_lenth
    
    def getPosiotion(self, mesh_lon, mesh_lat):
        center_lontitude = self.start_lon + (mesh_lon - 1) * self.lon_step + self.lon_step / 2
        center_latitude = self.start_lat + (mesh_lat - 1) * self.lat_step + self.lat_step / 2

        return center_lontitude, center_latitude


        
    