import json
import pandas as pd

class Posdecode():
    def __init__(self, map_path) -> None:
        addresses, citys = [], []
        
        with open(map_path) as reader:
            for item in reader:
                addresses.append(json.loads(item)['formatted_address'])
                city = json.loads(item)['addressComponent']['city']
                if not len(city):
                    city = 0
                citys.append(city)
            
        self.position_df = pd.DataFrame(dict(address = addresses, city = citys))

    def decode(self, df):
        res_df = pd.concat([df, self.position_df], axis=1)
    
        return res_df[res_df['city'] == 'Wuhan City']
        
