import pandas as pd
from tqdm import tqdm

class Textlize():
    def __init__(self, df) -> None:
        self.input = df[['TrafficNum', 'LowpowerNum', 'POI']]
        self.label = df['class']

    def promptCont(self):
        inputs = []
        for item in tqdm(self.input.iterrows(), total=self.input.shape[0], desc="Processing"):
            inputs.append(f"The grid's traffic flow is: {item[1]['TrafficNum']}, low battery vehicle count is: {item[1]['LowpowerNum']}, POI count is: {item[1]['POI']}.")
        return zip(inputs, self.label)

if __name__ == "__main__":
    df = pd.read_csv('/workspace/latest_project/temp_var/df.csv')
    textlize = Textlize(df)

    result = textlize.promptCont()

    result
# Textlize = Textlize()
