package network;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

class NodeNeighbor {
	public Node node;
	List<Node> neighbors;
	List<Node> outNeighbors;

	public NodeNeighbor(String id, int k) {
		node = new Node(id, k);
		neighbors = new ArrayList<Node>();
	}
}

class Node {
	public String id;
	public String subgraphId;
	public String exsubgraphId;
	public String exneighbor;
	public String midId = "";

	public Node(String id) {
		this.id = id;
	}

	public Node(String id, int k) {
		this.id = id;
		this.exneighbor = getNeighbor(id, k);
		this.exsubgraphId = getSubgraphId(exneighbor, k);
		this.subgraphId = getSubgraphId(this.id, k);
	}

	public static String getSubgraphId(String u, int k) {
		String s = u.substring(0, (int) Math.pow(2, k));
		String s2 = s.substring(s.length() / 2, s.length());
		return s2;
	}

	public static String getNeighbor(String u, int k) {
		String t = "";
		String s = u.substring(0, (int) Math.pow(2, k));
		String s1 = s.substring(0, s.length() / 2);
		String s2 = s.substring(s.length() / 2, s.length());
		String s3 = u.substring((int) Math.pow(2, k));
		if (s1.equals(s2)) {
			t = flipBits(s1) + flipBits(s2) + s3;
		} else {
			t = s2 + s1 + s3;
		}
		return t;
	}

	public static String flipBits(String input) {
		StringBuilder flipped = new StringBuilder();
		for (int i = 0; i < input.length(); i++) {
			char currentChar = input.charAt(i);
			if (currentChar == '0') {
				flipped.append('1');
			} else {
				flipped.append('0');
			}
		}
		return flipped.toString();
	}
}

public class FDSC {

	public static String D0, D1;

	public static int MinCommonDimension(String u, String v, int d) {
		int endIndex = (int) Math.pow(2, d);
		int beginIndex = endIndex;
		for (int i = d; i >= 2; i--) {
			beginIndex = endIndex / 2;
			String s = u.substring(beginIndex, endIndex);
			String t = v.substring(beginIndex, endIndex);
			if (!s.equals(t)) {
				return i;
			}
			endIndex = beginIndex;
		}
		return 1;
	}

	public static String SimpleRoute(String u, String v, int d) {
		d = MinCommonDimension(u, v, d);
		int m = (int) Math.pow(2, d);
		if (m == 2) {
			return u + "," + v;
		}
		int length = (int) Math.pow(2, d - 1);
		String subStr = subString(v, length, length);
		String s = replaceString(u, 0, length, subStr);
		String t = swap(length, 2 * length, s);
		String path = "";
		if (!s.equalsIgnoreCase(u) && !t.equalsIgnoreCase(v))
			path = SimpleRoute(u, s, d - 1) + "," + SimpleRoute(t, v, d - 1);
		if (!s.equalsIgnoreCase(u) && t.equalsIgnoreCase(v))
			path = SimpleRoute(u, s, d - 1) + "," + t;
		if (s.equalsIgnoreCase(u) && !t.equalsIgnoreCase(v))
			path = s + "," + SimpleRoute(t, v, d - 1);
		if (s.equalsIgnoreCase(u) && t.equalsIgnoreCase(v))
			path = s + "," + t;
		return path;
	}

	public static String subString(String content, int start, int length) {
		String s = content.substring(start, start + length);
		return s;
	}

	public static String replaceString(String content, int start, int length, String replacedStr) {
		String s = replacedStr + content.substring(start + length);
		return s;
	}

	public static String swap(int p1, int p2, String content) {
		String s1 = content.substring(0, p1);
		String s2 = content.substring(p1, p2);
		String s = s2 + s1 + content.substring(p2);
		return s;
	}

	public static boolean isEdge(String u, String v, int k) {
		if (Node.getNeighbor(u, k).equals(v)) {
			return true;
		}
		return false;
	}

	public static void NodeInnerNeighbors(NodeNeighbor nodeNeighbor, int k) {
		Node node = nodeNeighbor.node;
		List<Node> neighbors = getInnerNeighbors(node, k);
		nodeNeighbor.neighbors = neighbors;
	}

	public static List<Node> getInnerNeighbors(Node node, int k) {
		List<Node> neighbors = new ArrayList<Node>();
		String id = Node.flipBits(node.id.substring(0, 1)) + node.id.substring(1);
		Node vertex = new Node(id, k);
		neighbors.add(vertex);
		id = node.id.substring(0, 1) + Node.flipBits(node.id.substring(1, 2)) + node.id.substring(2);
		vertex = new Node(id, k);
		neighbors.add(vertex);

		for (int i = 1; i < k; i++) {
			id = Node.getNeighbor(node.id, i);
			vertex = new Node(id, k);
			neighbors.add(vertex);
		}
		return neighbors;
	}

	public static List<Node> getAllNeighbors(Node node, int d) {
		List<Node> neighbors = getInnerNeighbors(node, d);
		String id = Node.getNeighbor(node.id, d);
		Node vertex = new Node(id);
		neighbors.add(vertex);
		return neighbors;
	}

	public static boolean isAdjacent(Node u, Node v, int d) {
		List<Node> neighbors = getAllNeighbors(v, d);

		for (int i = 0; i < neighbors.size(); i++) {
			if (u.id.equals(neighbors.get(i).id)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isExAdjacent(Node u, Node v, int k) {
		List<Node> neighbors = getInnerNeighbors(v, k);

		for (int i = 0; i < neighbors.size(); i++) {
			if (u.exneighbor.equals(neighbors.get(i).id)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isDoubleConnection(Node u, Node v) {
		return isComplementString(u.subgraphId, v.subgraphId);
	}

	public static boolean isComplementString(String str1, String str2) {
		for (int i = 0; i < str1.length(); i++) {
			char char1 = str1.charAt(i);
			char char2 = str2.charAt(i);

			if (char1 == char2) {
				return false;
			}
		}
		return true;
	}

	public static Node reselectNode(List<Node> U, Node s, List<Node> V, int k) {
		List<Node> neighbors = getInnerNeighbors(s, k);
		Iterator<Node> iterator = neighbors.iterator();
		while (iterator.hasNext()) {
			Node node = iterator.next();
			if (node.exsubgraphId.equals(U.get(0).subgraphId)) {
				iterator.remove();
				continue;
			}
			if (node.exsubgraphId.equals(V.get(0).subgraphId)) {
				iterator.remove();
				continue;
			}
			List<Node> node_neighbors = getInnerNeighbors(node, k);
			boolean find = false;
			for (Node x : node_neighbors) {
				if (find)
					break;
				for (Node v : V) {
					if (x.id.equals(v.id)) {
						iterator.remove();
						find = true;
						break;
					}
				}
			}
		}

		for (Node node : neighbors) {
			List<Node> node_neighbors = getInnerNeighbors(node, k);
			for (Node n : node_neighbors) {
				if (!connectSameSubgraph(U, n, V.get(0))) {
					node.midId = n.id;
					node.exneighbor = n.exneighbor;
					node.exsubgraphId = n.exsubgraphId;
					return node;
				}
			}
		}
		return null;
	}

	public static Node selectNode(List<Node> U, Node s, Node v, int k) {
		Node node = null;
		List<Node> neighbors = getInnerNeighbors(s, k);
		boolean find = false;
		for (int i = 0; i < neighbors.size(); i++) {
			node = neighbors.get(i);
			if (!connectSameSubgraph(U, node, v)) {
				find = true;
				return node;
			}
		}
		if (!find)
			node = null;
		return node;
	}

	public static boolean connectSameSubgraph(List<Node> U, Node s, Node v) {

		for (int j = 0; j < U.size(); j++) {
			if (s.exsubgraphId.equals(U.get(j).exsubgraphId)) {
				return true;
			}
			if (s.exsubgraphId.equals(U.get(j).subgraphId)) {
				return true;
			}
			if (s.exsubgraphId.equals(v.subgraphId))
				return true;
		}
		return false;

	}

	public static void printPaths(List<String> paths) {
		for (String path : paths) {
			System.out.println("<" + path + ">");
		}
	}

	public static void print(List<Node> nodes) {
		for (Node node : nodes) {
			System.out.print(node.id + "\t");
		}
		System.out.println();
	}

	public static int getPathAverageLength(List<String> paths) {
		int sum = 0;

		for (String path : paths) {
			sum += path.split(",").length - 1;
		}
		return sum / paths.size();
	}

	public static void getSubgraphId(String u, String v, int k) {
		int endIndex = (int) Math.pow(2, k);
		int startIndex = endIndex / 2;
		D0 = u.substring(startIndex, endIndex);
		D1 = v.substring(startIndex, endIndex);
	}

	public static boolean isDisjoint(List<String> paths, String u, String v) {
		List<String> nodesList = new ArrayList<String>();
		nodesList.add(u);
		nodesList.add(v);
		for (int i = 0; i < paths.size(); i++) {
			String path = paths.get(i);
			String[] nodes = path.split(",");
			for (int j = 1; j < nodes.length - 1; j++) {
				if (nodesList.contains(nodes[j])) {
					System.out.println(path + " : " + nodes[j] + " 存在！");
					return false;
				} else {
					nodesList.add(nodes[j]);
				}
			}
		}
		return true;
	}

	public static boolean isPath(List<String> paths, int k) {
		boolean adjacent = true;
		for (int i = 0; i < paths.size(); i++) {
			String path = paths.get(i);

			String[] nodes = path.split(",");
			for (int j = 0; j < nodes.length - 1; j++) {
				Node node1 = new Node(nodes[j]);
				Node node2 = new Node(nodes[j + 1]);
				adjacent = isAdjacent(node1, node2, k);
				if (!adjacent) {
					System.out.println(node1.id + "," + node2.id + "不是边");
					return false;
				}
			}
		}
		return adjacent;
	}

	public static List<String> DisjointPath(NodeNeighbor start, NodeNeighbor end, int k, int d) {
		List<String> paths = new ArrayList<String>();
		NodeInnerNeighbors(start, k);
		start.neighbors.add(0, start.node);
		NodeInnerNeighbors(end, k);
		end.neighbors.add(0, end.node);

		List<Node> U = start.neighbors;
		List<Node> V = end.neighbors;
		Node u = start.node;
		Node v = end.node;

		int i, j;
		for (i = 0; i < U.size(); i++) {
			Node s = U.get(i);
			if (s.exsubgraphId.equals(v.subgraphId)) {
				for (j = 0; j < V.size(); j++) {
					Node t = V.get(j);
					if (s.exneighbor.equals(t.id)) {
						if (!s.id.equals(u.id)) {
							if (!t.id.equals(v.id))
								paths.add(u.id + "," + s.id + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + s.id + "," + t.id);
						} else {
							if (!t.id.equals(v.id))
								paths.add(u.id + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + v.id);
						}
						U.remove(i);
						V.remove(j);
						i--;
						break;
					}
				}
			}
		}

		for (i = 0; i < U.size(); i++) {
			Node s = U.get(i);
			if (s.exsubgraphId.equals(v.subgraphId)) {
				for (j = 0; j < V.size(); j++) {
					Node t = V.get(j);
					if (isExAdjacent(s, t, k)) {
						if (!s.id.equals(u.id)) {
							if (!t.id.equals(v.id))
								paths.add(u.id + "," + s.id + "," + s.exneighbor + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + s.id + "," + s.exneighbor + "," + t.id);
						} else {
							if (!t.id.equals(v.id))
								paths.add(u.id + "," + u.exneighbor + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + u.exneighbor + "," + v.id);
						}
						U.remove(i);
						V.remove(j);
						i--;
						break;
					}

				}
			}
		}

		for (i = 0; i < V.size(); i++) {
			Node t = V.get(i);
			if (t.exsubgraphId.equals(u.subgraphId)) {
				for (j = 0; j < U.size(); j++) {
					Node s = U.get(j);
					if (isExAdjacent(t, s, k)) {
						if (!u.id.equals(s.id)) {
							if (!v.id.equals(t.id))
								paths.add(u.id + "," + s.id + "," + t.exneighbor + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + s.id + "," + t.exneighbor + "," + v.id);
						} else {
							if (!v.id.equals(t.id))
								paths.add(u.id + "," + t.exneighbor + "," + t.id + "," + v.id);
							else
								paths.add(u.id + "," + t.exneighbor + "," + v.id);
						}
						U.remove(s);
						V.remove(t);
						i--;
						break;
					}
				}
			}
		}

		for (i = 0; i < U.size(); i++) {
			Node s = U.get(i);
			if (s.exsubgraphId.equals(v.subgraphId)) {
				Node neighbor = new Node(s.exneighbor, k);
				Node n = selectNode(U, neighbor, v, k);
				if (n == null) {
					n = reselectNode(U, neighbor, V, k);
					s.midId = "," + s.exneighbor + "," + n.id + "," + n.midId;
				} else
					s.midId = "," + s.exneighbor + "," + n.id;
				s.exneighbor = n.exneighbor;
				s.exsubgraphId = n.exsubgraphId;
			}
		}
		for (i = 0; i < V.size(); i++) {
			Node t = V.get(i);
			if (t.exsubgraphId.equals(u.subgraphId)) {
				Node neighbor = new Node(t.exneighbor, k);
				Node n = selectNode(V, neighbor, u, k);
				if (n == null) {
					n = reselectNode(V, neighbor, U, k);
					t.midId = "," + n.midId + "," + n.id + "," + t.exneighbor;
				} else
					t.midId = "," + n.id + "," + t.exneighbor;
				t.exneighbor = n.exneighbor;
				t.exsubgraphId = n.exsubgraphId;
			}
		}

		boolean result = false;
		for (i = 0; i <= U.size() - 2; i++) {
			Node ex1 = U.get(i);
			if (result == true)
				break;
			for (j = i + 1; j <= U.size() - 1; j++) {
				Node ex2 = U.get(j);
				if (ex1.exsubgraphId.equals(ex2.exsubgraphId)) {
					Node n = selectNode(U, ex2, v, k);
					ex2.midId = "," + n.id;
					ex2.exneighbor = n.exneighbor;
					ex2.exsubgraphId = n.exsubgraphId;
					result = true;
					break;
				}
			}
		}

		result = false;
		for (i = 0; i <= V.size() - 2; i++) {
			Node ex1 = V.get(i);
			if (result == true)
				break;
			for (j = i + 1; j <= V.size() - 1; j++) {
				Node ex2 = V.get(j);
				if (ex1.exsubgraphId.equals(ex2.exsubgraphId)) {
					Node n = selectNode(V, ex2, u, k);
					ex2.midId = "," + n.id;
					ex2.exneighbor = n.exneighbor;
					ex2.exsubgraphId = n.exsubgraphId;
					result = true;
					break;
				}
			}
		}
		List<Node> U1 = new ArrayList<Node>();
		List<Node> V1 = new ArrayList<Node>();
		for (i = 0; i < U.size(); i++) {
			String ex1 = U.get(i).exsubgraphId;
			for (j = 0; j < V.size(); j++) {
				String ex2 = V.get(j).exsubgraphId;
				if (ex1.equals(ex2)) {
					U1.add(U.get(i));
					V1.add(V.get(j));
					U.remove(i);
					V.remove(j);
					i--;
					break;
				}
			}
		}

		for (i = 0; i < U1.size(); i++) {
			Node s = U1.get(i);
			Node t = V1.get(i);
			String x = U1.get(i).exneighbor;
			String y = V1.get(i).exneighbor;
			if (u.id.equals(s.id)) {
				if (v.id.equals(t.id)) {
					paths.add(u.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + v.id);
				} else {
					paths.add(u.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + t.id + "," + v.id);
				}
			} else {
				if (v.id.equals(t.id)) {
					paths.add(u.id + "," + s.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + v.id);
				} else {
					paths.add(u.id + "," + s.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + t.id + ","
							+ v.id);
				}
			}
		}

		for (i = 0; i < U.size(); i++) {
			Node s = U.get(i);
			Node t = V.get(i);
			String x = U.get(i).exneighbor;
			String y = V.get(i).exneighbor;
			if (u.id.equals(s.id)) {
				if (v.id.equals(t.id)) {
					paths.add(u.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + v.id);
				} else {
					paths.add(u.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + t.id + "," + v.id);
				}
			} else {
				if (v.id.equals(t.id)) {
					paths.add(u.id + "," + s.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + v.id);
				} else {
					paths.add(u.id + "," + s.id + s.midId + "," + SimpleRoute(x, y, k) + t.midId + "," + t.id + ","
							+ v.id);
				}
			}
		}

		for (i = k + 1; i <= d; i++) {
			String s = Node.getNeighbor(u.id, i);
			String t = Node.getNeighbor(v.id, i);
			paths.add(u.id + "," + SimpleRoute(s, t, i) + "," + v.id);
		}

		return paths;
	}

	public static List<String> selectNodeTest(int num, int d) {
		ArrayList<String> UVnodes = new ArrayList<String>();
		int total = (int) Math.pow(2, d);
		for (int i = d; i > 2; i--) {
			int n = num / (d - 2);
			if (i == 3)
				n = num - n * (d - 3);
			for (int j = 0; j < n; j++) {
				String uv = pickTowNode(i, total);
				String[] list = uv.split(",");
				String vu = list[1] + "," + list[0];
				if (!UVnodes.contains(uv) && !UVnodes.contains(vu)) {
					UVnodes.add(uv);
				} else
					j--;
			}
		}
		return UVnodes;
	}

	public static String pickTowNode(int k, int total) {
		String ustr = randomBinaryString(total);
		String s = ustr.substring(0, (int) Math.pow(2, k));
		String ugraghid = s.substring(s.length() / 2);
		String vstr;
		do {
			vstr = randomBinaryString(total);
			s = vstr.substring(0, (int) Math.pow(2, k));
			String vgraghid = s.substring(s.length() / 2);
			if (!vgraghid.equals(ugraghid))
				break;
		} while (true);
		if ((int) Math.pow(2, k) < total) {
			String samStr = ustr.substring((int) Math.pow(2, k));
			vstr = s.substring(0, s.length()) + samStr;
		}
		return ustr + "," + vstr;
	}

	public static String randomBinaryString(int n) {
		Random random = new Random();
		StringBuilder str = new StringBuilder();
		for (int i = 1; i <= n; i++) {
			int bit = random.nextInt(2);
			str.append(bit);
		}
		return str.toString();
	}

	public static int getPathMaxLength(List<String> paths) {
		int MaxLength = 0;
		for (String path : paths) {
			int len = path.split(",").length - 1;
			if (len > MaxLength)
				MaxLength = len;
		}
		return MaxLength;
	}

	public static void main(String[] args) {

		getPathLen();

	}

	public static AbstractMap.SimpleEntry<List<Integer>, List<Integer>> getPathLen() {
		int k, d = 8, totalnum = 10000;

		List<Integer> pathAverageLength = new ArrayList<Integer>();
		List<Integer> pathMaxLength = new ArrayList<Integer>();

		for (int i = 1; i <= d; i++) {
			int averageLen = 0;
			int maxLen = 0;
			int num2 = 6 + 12 * (i - 1);
			List<String> uvNodes = FDSC2.selectNodeInFDSC2(num2, i);

			for (String uv : uvNodes) {
				String u = uv.split(",")[0];
				String v = uv.split(",")[1];
				List<String> paths = FDSC2.o2oInDSC(u, v, i);
				averageLen += getPathAverageLength(paths);
				maxLen += getPathMaxLength(paths);
				boolean result = isDisjoint(paths, u, v);
				if (!result)
					System.out.println("F2 isDisjoint:" + result);
				result = isPath(paths, i);
				if (!result)
					System.out.println("F2 isPath:" + result);
			}
			k = 2;
			int num4 = 50 + 200 * (i - 2);
			if (i >= 2) {
				List<String> nodes = FDSC4.selectNodeInFDSC4(num4, i);
				for (String uv : nodes) {
					String from = uv.split(",")[0];
					String to = uv.split(",")[1];
					NodeNeighbor u = new NodeNeighbor(from, k);
					NodeNeighbor v = new NodeNeighbor(to, k);
					List<String> paths = FDSC4.DisjointPath(u, v, k, i);
					averageLen += getPathAverageLength(paths);
					maxLen += getPathMaxLength(paths);
					boolean result = isDisjoint(paths, from, to);
					if (!result)
						System.out.println("" + result);
					result = FDSC.isPath(paths, i);
					if (!result)
						System.out.println(result);
				}
			}
			if (i >= 3) {
				List<String> list = selectNodeTest(totalnum - num2 - num4, i);
				int index = 1;
				for (String str : list) {
					String[] uv = str.split(",");
					k = MinCommonDimension(uv[0], uv[1], i);
				}
				for (String str : list) {
					String[] uv = str.split(",");
					k = MinCommonDimension(uv[0], uv[1], i);
					NodeNeighbor u = new NodeNeighbor(uv[0], k);
					NodeNeighbor v = new NodeNeighbor(uv[1], k);
					List<String> paths = DisjointPath(u, v, k, i);
					averageLen += getPathAverageLength(paths);
					maxLen += getPathMaxLength(paths);
					boolean result = isDisjoint(paths, uv[0], uv[1]);
					if (!result)
						System.out.println("F" + i + "isDisjoint:" + result);
					result = isPath(paths, i);
					if (!result)
						System.out.println("isPath:" + result);
				}
			}
			if (i == 1)
				totalnum = num2;
			if (i == 2)
				totalnum = num2 + num4;
			System.out.println(i + " " + totalnum);
			pathAverageLength.add(averageLen / totalnum);
			pathMaxLength.add(maxLen / totalnum);
			System.out.println(i + "维FDSC的max长度：" + maxLen / totalnum + "  平均长度：" + averageLen / totalnum);
			totalnum = 10000;
		}
		return new AbstractMap.SimpleEntry<>(pathAverageLength, pathMaxLength);
	}
}
