package network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class FDSC2 {

	public static List<String> o2oInDSC2(String u, String v, int d) {
		List<String> paths = new ArrayList<String>();
		paths.add(u + "," + v);
		String suffix = "";
		if (d > 1)
			suffix = u.substring(2);
		Set<String> nodes = new HashSet<String>();
		nodes.add("00" + suffix);
		nodes.add("01" + suffix);
		nodes.add("10" + suffix);
		nodes.add("11" + suffix);
		nodes.remove(u);
		nodes.remove(v);
		for (Iterator iterator = nodes.iterator(); iterator.hasNext();) {
			String node = (String) iterator.next();
			paths.add(u + "," + node + "," + v);
		}
		return paths;
	}

	public static List<String> o2oInDSC(String u, String v, int d) {
		List<String> paths = o2oInDSC2(u, v, d);
		if (d > 1) {
			String ui, vi;
			for (int i = 2; i <= d; i++) {
				String m1 = u.substring(0, (int) Math.pow(2, i - 1));
				String m2 = u.substring((int) Math.pow(2, i - 1), (int) Math.pow(2, i));
				if (m1.equalsIgnoreCase(m2)) {
					ui = reverse(m1) + reverse(m2) + u.substring((int) Math.pow(2, i));
				} else {
					ui = m2 + m1 + u.substring((int) Math.pow(2, i));
				}
				String n1 = v.substring(0, (int) Math.pow(2, i - 1));
				String n2 = v.substring((int) Math.pow(2, i - 1), (int) Math.pow(2, i));
				if (n1.equalsIgnoreCase(n2)) {
					vi = reverse(n1) + reverse(n2) + v.substring((int) Math.pow(2, i));
				} else {
					vi = n2 + n1 + v.substring((int) Math.pow(2, i));
				}
				String p = FDSC.SimpleRoute(ui, vi, i);
				paths.add(u + "," + p + "," + v);
			}
		}

		return paths;
	}

	public static String reverse(String u) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < u.length(); i++) {
			char c = u.charAt(i);
			if (c == '0')
				sb.append("1");
			else
				sb.append("0");
		}
		return sb.toString();
	}

	public static List<String> selectNodeInFDSC2(int num, int d) {
		List<String> nodes = new ArrayList<String>();
		int n = (int) Math.pow(2, d);
		for (int i = 0; i < num; i++) {
			List<String> first2bit = new ArrayList<>(Arrays.asList("00", "01", "10", "11"));
			String u = first2bit.get(new Random().nextInt(4));
			first2bit.remove(u);
			String v = first2bit.get(new Random().nextInt(3));
			String str = RandomBinaryString(n - 2);
			u = u + str;
			v = v + str;
			if (!nodes.contains(u + "," + v) && !nodes.contains(v + "," + u)) {
				nodes.add(u + "," + v);
			} else
				i--;
		}
		return nodes;
	}

	private static String RandomBinaryString(int n) {
		StringBuilder binaryString = new StringBuilder();
		for (int j = 0; j < n; j++) {
			int bit = new Random().nextInt(2);
			binaryString.append(bit);
		}
		return binaryString.toString();
	}
}
