package network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class FDSC4 {
	public static String D0, D1;
	public static int MinCommonDimension(String u, String v, int d) {
		int endIndex = (int) Math.pow(2, d);
		int beginIndex = endIndex;
		for (int i = d; i >= 2; i--) {
			beginIndex = endIndex / 2;
			String s = u.substring(beginIndex, endIndex);
			String t = v.substring(beginIndex, endIndex);
			if (!s.equals(t)) {
				return i;
			}
			endIndex = beginIndex;
		}
		return 1;
	}

	public static String SimpleRoute(String u, String v, int d) {
		d = MinCommonDimension(u, v, d);
		int m = (int) Math.pow(2, d);
		if (m == 2) {
			return u + "," + v;
		}
		int length = (int) Math.pow(2, d - 1);
		String subStr = subString(v, length, length);
		String s = replaceString(u, 0, length, subStr);
		String t = swap(length, 2 * length, s);
		String path = "";
		if (!s.equalsIgnoreCase(u) && !t.equalsIgnoreCase(v))
			path = SimpleRoute(u, s, d - 1) + "," + SimpleRoute(t, v, d - 1);
		if (!s.equalsIgnoreCase(u) && t.equalsIgnoreCase(v))
			path = SimpleRoute(u, s, d - 1) + "," + t;
		if (s.equalsIgnoreCase(u) && !t.equalsIgnoreCase(v))
			path = s + "," + SimpleRoute(t, v, d - 1);
		if (s.equalsIgnoreCase(u) && t.equalsIgnoreCase(v))
			path = s + "," + t;
		return path;
	}
	public static String subString(String content, int start, int length) {
		String s = content.substring(start, start + length);
		return s;
	}

	public static String replaceString(String content, int start, int length, String replacedStr) {
		String s = replacedStr + content.substring(start + length);
		return s;
	}

	public static String swap(int p1, int p2, String content) {
		String s1 = content.substring(0, p1);
		String s2 = content.substring(p1, p2);
		String s = s2 + s1 + content.substring(p2);
		return s;
	}

	public static List<String> selectNodeInFDSC4(int num, int d) {
		List<String> nodes = new ArrayList<String>();
		
		int n = (int) Math.pow(2, d);//d>1
		for (int i = 0; i < num; i++) {
			List<String> bit2 = new ArrayList<>(Arrays.asList("00", "01", "10", "11"));
			String u = bit2.get(new Random().nextInt(4));	
			bit2.remove(u);
			String v = bit2.get(new Random().nextInt(3));
			String str=RandomBinaryString(n-4);		
			u=RandomBinaryString(2)+u+str;
			v=RandomBinaryString(2)+v+str;
			if (!nodes.contains(u + "," + v)&&!nodes.contains(v + "," + u)){
				nodes.add(u + "," + v);
			}			
			else
				i--;
		}
		return nodes;
	}
	private static String RandomBinaryString(int n) {
		StringBuilder binaryString = new StringBuilder();
		for (int j = 0; j < n; j++) {
			int bit = new Random().nextInt(2); // 随机生成 0 或 1
			binaryString.append(bit);
		}
		return binaryString.toString();
	}

	public static boolean isEdge(String u, String v, int k) {
		if (Node.getNeighbor(u, k).equals(v)) {
			return true;
		}
		return false;
	}

	public static void NodeInnerNeighbors(NodeNeighbor nodeNeighbor, int k) {
		Node node = nodeNeighbor.node;
		List<Node> neighbors = getInnerNeighbors(node, k);
		nodeNeighbor.neighbors = neighbors;
	}
	public static List<Node> getInnerNeighbors(Node node, int k) {
		List<Node> neighbors = new ArrayList<Node>();
		String id = Node.flipBits(node.id.substring(0, 1)) + node.id.substring(1);
		Node vertex = new Node(id, k);
		neighbors.add(vertex);
		// 补
		id = node.id.substring(0, 1) + Node.flipBits(node.id.substring(1, 2)) + node.id.substring(2);
		vertex = new Node(id, k);
		neighbors.add(vertex);

		for (int i = 1; i < k; i++) {
			id = Node.getNeighbor(node.id, i);
			vertex = new Node(id, k);
			neighbors.add(vertex);
		}
		return neighbors;
	}

	public static boolean isAdjacent(Node u, Node v, int k) {
		List<Node> neighbors = getInnerNeighbors(v, k);

		for (int i = 0; i < neighbors.size(); i++) {
			if (u.id.equals(neighbors.get(i).id)) {
				return true;
			}
		}
		return false;
	}

	public static boolean isExAdjacent(Node u, Node v, int k) {
		List<Node> neighbors = getInnerNeighbors(v, k);

		for (int i = 0; i < neighbors.size(); i++) {
			if (u.exneighbor.equals(neighbors.get(i).id)) {
				return true;
			}
		}
		return false;
	}
	public static void NodeTodifSubgraph(NodeNeighbor u) {
		List<Node> U = u.neighbors;

	}

	public static boolean isDoubleConnection(Node u, Node v) {
		return isComplementString(u.subgraphId, v.subgraphId);
	}

	public static boolean isComplementString(String str1, String str2) {
		for (int i = 0; i < str1.length(); i++) {
			char char1 = str1.charAt(i);
			char char2 = str2.charAt(i);
			if (char1 == char2) {
				return false;
			}
		}
		return true;
	}

	public static Node selectNode(List<Node> U, Node s, int k) {
		Node node = null;
		List<Node> neighbors = getInnerNeighbors(s, k);
		int i, j;
		for (i = 0; i < neighbors.size(); i++) {
			Node n = neighbors.get(i);
			if (!connectSameSubgraph(U, n)) {
				return n;
			}
		}
		return node;
	}

	public static boolean connectSameSubgraph(List<Node> U, Node s) {
		for (int j = 0; j < U.size(); j++) {
			if (s.exsubgraphId.equals(U.get(j).exsubgraphId)) {
				return true;
			}
			if (s.exsubgraphId.equals(U.get(j).subgraphId)) {
				return true;
			}
		}
		return false;

	}

	public static List<String> DisjointPath(NodeNeighbor start, NodeNeighbor end, int k,int d) {
		List<String> paths = new ArrayList<String>();
		NodeInnerNeighbors(start, k);
		start.neighbors.add(0, start.node);
		NodeInnerNeighbors(end, k);
		end.neighbors.add(0, end.node);
		List<Node> U = start.neighbors;
		List<Node> V = end.neighbors;
		Node u = start.node;
		Node v = end.node;
    	int i,j;
    	for(i=0;i<U.size();i++){
    		Node s = U.get(i);
    		if(s.exsubgraphId.equals(v.subgraphId)) {
	    		for(j=0;j<V.size(); j++){
	    			Node t = V.get(j);
	    			if(s.exneighbor.equals(t.id)) {
	    				if(!s.id.equals(u.id)) {
	    					if(!t.id.equals(v.id))
	    						paths.add(u.id + "," + s.id +"," + t.id + "," + v.id);
	    					else
	    						paths.add(u.id + "," + s.id +"," + t.id);
	    				}else {
	    					if(!t.id.equals(v.id))
	    						paths.add(u.id  + "," + t.id + "," + v.id);
	    					else
	    						paths.add(u.id + "," + v.id);
	    				}
	    				U.remove(i);
	    				V.remove(j);
	    				i--;
	    				break;
	    			}
	    		}
    		}
    	}
    	
    	for(i=0;i<U.size();i++){
    		Node s = U.get(i);
    		if(s.exsubgraphId.equals(v.subgraphId)) {
	    		for(j=0;j<V.size(); j++){
	    			Node t = V.get(j);
	    			if(isExAdjacent(s,t,k)) {
	    				if(!s.id.equals(u.id)) {
	    					if(!t.id.equals(v.id))
	    						paths.add(u.id + "," + s.id + "," + s.exneighbor + "," + t.id + "," + v.id);
	    					else
	    						paths.add(u.id + "," + s.id + "," + s.exneighbor + "," + t.id);
	    				}else {
	    					if(!t.id.equals(v.id))
	    						paths.add( u.id + "," + u.exneighbor  + "," + t.id +  "," + v.id);
	    					else
	    						paths.add(u.id +  "," + u.exneighbor+ "," + v.id );
	    				}
	    				U.remove(i);
	    				V.remove(j);
	    				i--;
	    				break;
	    			}
	    		}
    		}
    	}

    	for(i=0;i<V.size();i++){
    		Node t = V.get(i);
    		if(t.exsubgraphId.equals(u.subgraphId)) {
	    		for(j=0;j<U.size(); j++){
	    			Node s = U.get(j);
	    			if(isExAdjacent(t,s,k)) {
	    				if(!u.id.equals(s.id)) {
	    					if(!v.id.equals(t.id))
	    						paths.add(u.id + "," + s.id +"," + t.exneighbor + "," + t.id + "," + v.id);
	    					else
	    						paths.add(u.id + "," + s.id +"," + t.exneighbor +","+ v.id);
	    				}
	    				else {
	    					if(!v.id.equals(t.id))
	    						paths.add( u.id +"," + t.exneighbor + "," + t.id + "," + v.id);
	    					else
	    						paths.add( u.id +"," + t.exneighbor +"," + v.id);
	    				}
	    				U.remove(s);
	    				V.remove(t);
	    				i--;
	    				break;
	    			}
	    		}
    		}
    	}

    	for(i=0;i<U.size();i++){
    		Node s = U.get(i);
    		if(s.exsubgraphId.equals(v.subgraphId)) {
	    			Node neighbor = new Node(s.exneighbor, k);
	    			Node n = selectNode(U,neighbor,k);
	    			s.midId = s.exneighbor + "," + n.id;
	    			s.exneighbor = n.exneighbor;
	    			s.exsubgraphId = n.exsubgraphId;
    		}
    	}
    	for(i=0;i<V.size();i++){
    		Node t = V.get(i);
    		if(t.exsubgraphId.equals(u.subgraphId)) {
	    			Node neighbor = new Node(t.exneighbor, k);
	    			Node n = selectNode(V,neighbor,k);
	    			t.midId = n.id+ ","+t.exneighbor;
	    			t.exneighbor = n.exneighbor;
	    			t.exsubgraphId = n.exsubgraphId;
    		}
    	}
    	
    	boolean result = false;
		List<Node> U1 = new ArrayList();
    	List<Node> V1 = new ArrayList();
    	for (i = 0; i < U.size(); i++) {
    		String ex1 = U.get(i).exsubgraphId;
    		for(j=0;j<V.size(); j++){
    			String ex2 = V.get(j).exsubgraphId;
    			if(ex1.equals(ex2)) {
    				U1.add(U.get(i));
    				V1.add(V.get(j));
    				U.remove(i);
    				V.remove(j);
    				i--;
    				break;
    			}
    		}
    	}
    	
    	for (i = 0; i < U1.size(); i++) {
        	Node s = U1.get(i);
        	Node t = V1.get(i);
            String x = U1.get(i).exneighbor;
            String y = V1.get(i).exneighbor;
            if(u.id.equals(s.id)) {
            	if(v.id.equals(t.id)) {
            		paths.add(u.id + s.midId +"," + SimpleRoute(x,y,k)  + t.midId +","+ v.id);
            	}else {
            		paths.add(u.id + s.midId +"," + SimpleRoute(x,y,k)  + t.midId +"," + t.id + "," + v.id);
            	}
            }else {
            	if(v.id.equals(t.id)) {
            		paths.add(u.id +"," + s.id + s.midId + "," + SimpleRoute(x,y,k)  + t.midId +","+ v.id );
            	}else {
            		paths.add( u.id +"," + s.id + s.midId + "," + SimpleRoute(x,y,k)  + t.midId +"," + t.id + "," + v.id );
            	}
            }      
        }
    	
        for (i = 0; i < U.size(); i++) {
        	Node s = U.get(i);
        	Node t = V.get(i);
            String x = U.get(i).exneighbor;
            String y = V.get(i).exneighbor;
            if(u.id.equals(s.id)) {
            	if(v.id.equals(t.id)) {
            		paths.add(u.id + s.midId +"," + SimpleRoute(x,y,k)  + t.midId +","+ v.id);
            	
            	}else {
            		paths.add( u.id + s.midId +"," + SimpleRoute(x,y,k) + t.midId +"," + t.id + "," + v.id);
            		
            	}
            }else {
            	if(v.id.equals(t.id)) {
            		paths.add( u.id +"," + s.id + s.midId + "," + SimpleRoute(x,y,k) + t.midId +","+ v.id);
            	
            	}else {
            		paths.add(u.id +"," + s.id + s.midId + "," + SimpleRoute(x,y,k) + t.midId +"," + t.id + "," + v.id);
            	}
            }
        }
        
    	for (i = k + 1; i <= d; i++) {
			String s = Node.getNeighbor(u.id, i);
			String t = Node.getNeighbor(v.id, i);
			paths.add(u.id + "," + SimpleRoute(s, t, i) + "," + v.id);
		}
        
        return paths;
	}

	public static void printPaths(List<String> paths) {
		for (String path : paths) {
			System.out.println(path);
		}
	}

	public static void getSubgraphId(String u, String v, int k) {
		int endIndex = (int) Math.pow(2, k);
		int startIndex = endIndex / 2;
		D0 = u.substring(startIndex, endIndex);
		D1 = v.substring(startIndex, endIndex);
	}

	 public static boolean isDisjoint(List<String> paths, String u, String v) {
	    	boolean result = true;
	    	List<String> nodesList = new ArrayList<String>();
	    	nodesList.add(u);
	    	nodesList.add(v);
	    	for(int i=0;i<paths.size();i++) {
	    		String path = paths.get(i);
	        	String[] nodes=path.split(",");
	        	for(int j=1;j<nodes.length-1;j++) {
	        		if(nodesList.contains(nodes[j])) {
	        			System.out.println(path + " : " + nodes[j] + " 存在！");
	        			return false;
	        		}else {
	        			nodesList.add(nodes[j]);
	        		}
	        	}
	    	}
	    	return result;
	    } 
}
